/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.hopper;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.block.IInventoryHolder;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.hopper.EnergyHopperBlock;
import owmii.powah.config.EnergyHopperConfig;

public class EnergyHopperTile
extends AbstractEnergyStorage<Tier, EnergyHopperConfig, EnergyHopperBlock>
implements IInventoryHolder {
    public EnergyHopperTile(Tier variant) {
        super(Tiles.ENERGY_HOPPER, (Enum)variant);
    }

    public EnergyHopperTile() {
        this(Tier.STARTER);
    }

    protected int postTick(World world) {
        int[] extracted = new int[]{0};
        if (!this.isRemote() && this.checkRedstone()) {
            Direction side = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
            TileEntity tile = world.func_175625_s(this.field_174879_c.func_177972_a(side));
            long charging = ((EnergyHopperConfig)this.getConfig()).getChargingSpeed((Tier)this.variant);
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190916_E() != 1) continue;
                    extracted[0] = (int)((long)extracted[0] + this.chargeItem(stack, charging));
                }
            } else if (tile != null) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                    for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                        ItemStack stack = iItemHandler.getStackInSlot(i);
                        if (stack.func_190916_E() != 1) continue;
                        extracted[0] = (int)((long)extracted[0] + this.chargeItem(stack, charging));
                    }
                });
            }
        }
        return extracted[0] > 0 ? 5 : super.postTick(world);
    }

    public boolean keepEnergy() {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return false;
    }
}

