/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network.to_server;

import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGeneratorsGuiInteract
implements IMekanismPacket {
    private final GeneratorsGuiInteraction interaction;
    private final BlockPos tilePosition;
    private final double extra;

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, TileEntity tile) {
        this(interaction, tile.func_174877_v());
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, TileEntity tile, double extra) {
        this(interaction, tile.func_174877_v(), extra);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0.0);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition, double extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)this.tilePosition)) != null) {
            this.interaction.consume(tile, (PlayerEntity)player, this.extra);
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.interaction);
        buffer.func_179255_a(this.tilePosition);
        buffer.writeDouble(this.extra);
    }

    public static PacketGeneratorsGuiInteract decode(PacketBuffer buffer) {
        return new PacketGeneratorsGuiInteract((GeneratorsGuiInteraction)buffer.func_179257_a(GeneratorsGuiInteraction.class), buffer.func_179259_c(), buffer.readDouble());
    }

    public static enum GeneratorsGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                ((TileEntityFusionReactorController)((Object)tile)).setInjectionRateFromPacket((int)Math.round(extra));
            } else if (tile instanceof TileEntityFissionReactorCasing) {
                ((TileEntityFissionReactorCasing)((Object)tile)).setRateLimitFromPacket((double)extra);
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorLogicAdapter) {
                ((TileEntityFissionReactorLogicAdapter)tile).setLogicTypeFromPacket(TileEntityFissionReactorLogicAdapter.FissionReactorLogic.byIndexStatic((int)Math.round(extra)));
            } else if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                ((TileEntityFusionReactorLogicAdapter)tile).setLogicTypeFromPacket(TileEntityFusionReactorLogicAdapter.FusionReactorLogic.byIndexStatic((int)Math.round(extra)));
            }
        })),
        FISSION_ACTIVE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorCasing) {
                ((TileEntityFissionReactorCasing)((Object)tile)).setReactorActive(Math.round(extra) == 1L);
            }
        }));

        private final TriConsumer<TileEntityMekanism, PlayerEntity, Double> consumerForTile;

        private GeneratorsGuiInteraction(TriConsumer<TileEntityMekanism, PlayerEntity, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, PlayerEntity player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }
}

