/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.gear.mekasuit;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

@ParametersAreNonnullByDefault
public class ModuleGeothermalGeneratorUnit
implements ICustomModule<ModuleGeothermalGeneratorUnit> {
    public void tickServer(IModule<ModuleGeothermalGeneratorUnit> module, PlayerEntity player) {
        IEnergyContainer energyContainer = module.getEnergyContainer();
        if (energyContainer != null && !energyContainer.getNeeded().isZero()) {
            double highestScaledDegrees = 0.0;
            double legHeight = player.func_213453_ef() ? 0.6 : 0.7;
            Map fluidsIn = MekanismUtils.getFluidsIn((PlayerEntity)player, bb -> new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, Math.min(bb.field_72338_b + legHeight, bb.field_72337_e), bb.field_72334_f));
            for (Map.Entry entry : fluidsIn.entrySet()) {
                double scaledDegrees;
                MekanismUtils.FluidInDetails details = (MekanismUtils.FluidInDetails)entry.getValue();
                double height = details.getMaxHeight();
                if (height < 0.25) continue;
                double temperature = 0.0;
                List positions = details.getPositions();
                for (BlockPos position : positions) {
                    temperature += (double)((Fluid)entry.getKey()).getAttributes().getTemperature((IBlockDisplayReader)player.field_70170_p, position);
                }
                if (!((temperature /= (double)positions.size()) > 300.0) || !((scaledDegrees = (temperature - 300.0) * height / legHeight) > highestScaledDegrees)) continue;
                highestScaledDegrees = scaledDegrees;
            }
            if (highestScaledDegrees > 0.0 || player.func_70027_ad()) {
                if (highestScaledDegrees < 200.0 && player.func_70027_ad()) {
                    highestScaledDegrees = 200.0;
                }
                FloatingLong rate = ((FloatingLong)MekanismGeneratorsConfig.gear.mekaSuitGeothermalChargingRate.get()).multiply((long)module.getInstalledCount()).multiply(highestScaledDegrees);
                energyContainer.insert(rate, Action.EXECUTE, AutomationType.MANUAL);
            }
        }
    }

    @Nullable
    public ICustomModule.ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<ModuleGeothermalGeneratorUnit> module, DamageSource damageSource) {
        if (damageSource.func_76347_k()) {
            float ratio = MekanismGeneratorsConfig.gear.mekaSuitHeatDamageReductionRatio.get() * ((float)module.getInstalledCount() / (float)module.getData().getMaxStackSize());
            return new ICustomModule.ModuleDamageAbsorbInfo(() -> ratio, () -> FloatingLong.ZERO);
        }
        return null;
    }
}

