/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlockTypes;
import mekanism.generators.common.tile.fission.TileEntityControlRodAssembly;
import mekanism.generators.common.tile.fission.TileEntityFissionFuelAssembly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class FissionReactorValidator
extends CuboidStructureValidator<FissionReactorMultiblockData> {
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.func_177230_c();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_REACTOR_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_REACTOR_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_REACTOR_LOGIC_ADAPTER})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    protected boolean validateInner(BlockState state, Long2ObjectMap<IChunk> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is((Block)state.func_177230_c(), (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_FUEL_ASSEMBLY, GeneratorsBlockTypes.CONTROL_ROD_ASSEMBLY});
    }

    public FormationProtocol.FormationResult postcheck(FissionReactorMultiblockData structure, Set<BlockPos> innerNodes, Long2ObjectMap<IChunk> chunkMap) {
        HashMap<AssemblyPos, FuelAssembly> map = new HashMap<AssemblyPos, FuelAssembly>();
        HashSet<BlockPos> fuelAssemblyCoords = new HashSet<BlockPos>();
        int assemblyCount = 0;
        int surfaceArea = 0;
        for (BlockPos blockPos : innerNodes) {
            TileEntity tile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, (BlockPos)blockPos);
            AssemblyPos pos = new AssemblyPos(blockPos.func_177958_n(), blockPos.func_177952_p());
            FuelAssembly assembly = (FuelAssembly)map.get(pos);
            if (tile instanceof TileEntityFissionFuelAssembly) {
                if (assembly == null) {
                    map.put(pos, new FuelAssembly(blockPos, false));
                } else {
                    assembly.fuelAssemblies.add(blockPos);
                }
                ++assemblyCount;
                surfaceArea += 6;
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!fuelAssemblyCoords.contains(blockPos.func_177972_a(side))) continue;
                    surfaceArea -= 2;
                }
                fuelAssemblyCoords.add(blockPos);
                structure.internalLocations.add(blockPos);
                continue;
            }
            if (!(tile instanceof TileEntityControlRodAssembly)) continue;
            if (assembly == null) {
                map.put(pos, new FuelAssembly(blockPos, true));
                continue;
            }
            if (assembly.controlRodAssembly != null) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_EXTRA_CONTROL_ROD, (BlockPos)blockPos);
            }
            assembly.controlRodAssembly = blockPos;
        }
        if (map.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_MISSING_FUEL_ASSEMBLY);
        }
        for (Map.Entry entry : map.entrySet()) {
            FuelAssembly assembly = (FuelAssembly)entry.getValue();
            FormationProtocol.FormationResult result = assembly.validate((AssemblyPos)entry.getKey());
            if (!result.isFormed()) {
                return result;
            }
            structure.assemblies.add(assembly.build());
        }
        structure.fuelAssemblies = assemblyCount;
        structure.surfaceArea = surfaceArea;
        return FormationProtocol.FormationResult.SUCCESS;
    }

    public static class AssemblyPos {
        private final int x;
        private final int z;

        public AssemblyPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof AssemblyPos && ((AssemblyPos)obj).x == this.x && ((AssemblyPos)obj).z == this.z;
        }
    }

    public static class FormedAssembly {
        private final BlockPos pos;
        private final int height;

        public FormedAssembly(BlockPos pos, int height) {
            this.pos = pos;
            this.height = height;
        }

        public CompoundNBT write() {
            CompoundNBT ret = new CompoundNBT();
            ret.func_74768_a("x", this.pos.func_177958_n());
            ret.func_74768_a("y", this.pos.func_177956_o());
            ret.func_74768_a("z", this.pos.func_177952_p());
            ret.func_74768_a("height", this.height);
            return ret;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getHeight() {
            return this.height;
        }

        public static FormedAssembly read(CompoundNBT nbt) {
            return new FormedAssembly(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), nbt.func_74762_e("height"));
        }
    }

    public static class FuelAssembly {
        public final SortedSet<BlockPos> fuelAssemblies = new TreeSet<BlockPos>(Comparator.comparingInt(Vector3i::func_177956_o));
        public BlockPos controlRodAssembly;

        public FuelAssembly(BlockPos start, boolean isControlRod) {
            if (isControlRod) {
                this.controlRodAssembly = start;
            } else {
                this.fuelAssemblies.add(start);
            }
        }

        public FormationProtocol.FormationResult validate(AssemblyPos assemblyPos) {
            if (this.controlRodAssembly == null) {
                return FormationProtocol.FormationResult.fail((ITextComponent)GeneratorsLang.FISSION_INVALID_MISSING_CONTROL_ROD.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismLang.GENERIC_PARENTHESIS.translate(new Object[]{MekanismLang.GENERIC_WITH_COMMA.translate(new Object[]{assemblyPos.x, assemblyPos.z})})}));
            }
            if (this.fuelAssemblies.isEmpty()) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_BAD_FUEL_ASSEMBLY, (BlockPos)this.controlRodAssembly);
            }
            int prevY = -1;
            for (BlockPos coord : this.fuelAssemblies) {
                if (prevY != -1 && coord.func_177956_o() != prevY + 1) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_MALFORMED_FUEL_ASSEMBLY, (BlockPos)coord);
                }
                prevY = coord.func_177956_o();
            }
            if (this.controlRodAssembly.func_177956_o() != prevY + 1) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_BAD_CONTROL_ROD, (BlockPos)this.controlRodAssembly);
            }
            return FormationProtocol.FormationResult.SUCCESS;
        }

        public FormedAssembly build() {
            BlockPos base = this.fuelAssemblies.first();
            return new FormedAssembly(base, this.fuelAssemblies.size());
        }
    }
}

