/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.client.model.ModelTurbine;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.vector.Vector3f;

@ParametersAreNonnullByDefault
public class RenderTurbineRotor
extends MekanismTileEntityRenderer<TileEntityTurbineRotor> {
    public static RenderTurbineRotor INSTANCE;
    private static final float BASE_SPEED = 512.0f;
    public final ModelTurbine model = new ModelTurbine();

    public RenderTurbineRotor(TileEntityRendererDispatcher renderer) {
        super(renderer);
        INSTANCE = this;
    }

    protected void render(TileEntityTurbineRotor tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.getMultiblock() == null) {
            this.render(tile, matrix, this.model.getBuffer(renderer), light, overlayLight);
        }
    }

    public void render(TileEntityTurbineRotor tile, MatrixStack matrix, IVertexBuilder buffer, int light, int overlayLight) {
        int housedBlades = tile.getHousedBlades();
        if (housedBlades == 0) {
            return;
        }
        int baseIndex = tile.getPosition() * 2;
        if (!Minecraft.func_71410_x().func_147113_T()) {
            if (tile.getMultiblock() != null && TurbineMultiblockData.clientRotationMap.containsKey((Object)tile.getMultiblock())) {
                float rotateSpeed = TurbineMultiblockData.clientRotationMap.getFloat((Object)tile.getMultiblock()) * 512.0f;
                tile.rotationLower = (tile.rotationLower + rotateSpeed * (1.0f / (float)(baseIndex + 1))) % 360.0f;
                tile.rotationUpper = (tile.rotationUpper + rotateSpeed * (1.0f / (float)(baseIndex + 2))) % 360.0f;
            } else {
                tile.rotationLower %= 360.0f;
                tile.rotationUpper %= 360.0f;
            }
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, -1.0, 0.5);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tile.rotationLower));
        this.model.render(matrix, buffer, light, overlayLight, baseIndex);
        matrix.func_227865_b_();
        if (housedBlades == 2) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, -0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tile.rotationUpper));
            this.model.render(matrix, buffer, light, overlayLight, baseIndex + 1);
            matrix.func_227865_b_();
        }
    }

    protected String getProfilerSection() {
        return "turbineRotor";
    }

    public boolean shouldRenderOffScreen(TileEntityTurbineRotor tile) {
        return tile.getMultiblock() == null && tile.getHousedBlades() > 0;
    }
}

