/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.providers.IItemProvider;
import mekanism.client.jei.CatalystRegistryHelper;
import mekanism.client.jei.MekanismJEI;
import mekanism.generators.client.jei.FissionReactorRecipeCategory;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class GeneratorsJEI
implements IModPlugin {
    private static final ResourceLocation FISSION = MekanismGenerators.rl("fission");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MekanismGenerators.rl("jei_plugin");
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registry) {
        MekanismJEI.registerItemSubtypes((ISubtypeRegistration)registry, (List)GeneratorsItems.ITEMS.getAllItems());
        MekanismJEI.registerItemSubtypes((ISubtypeRegistration)registry, (List)GeneratorsBlocks.BLOCKS.getAllBlocks());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FissionReactorRecipeCategory(guiHelper, FISSION)});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register((IRecipeCatalystRegistration)registry, (ResourceLocation)FISSION, (IItemProvider[])new IItemProvider[]{GeneratorsBlocks.FISSION_REACTOR_CASING, GeneratorsBlocks.FISSION_REACTOR_PORT, GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER, GeneratorsBlocks.FISSION_FUEL_ASSEMBLY, GeneratorsBlocks.CONTROL_ROD_ASSEMBLY});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(FissionReactorRecipeCategory.getFissionRecipes(), FISSION);
    }
}

