/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.guide;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import shetiphian.core.ShetiPhianCore;
import shetiphian.guide.GuideLoader;

class GuidePage {
    private String id = "";
    private String title = "";
    private EnumPageType type = EnumPageType.TEXT;
    private List<String> linklist = new ArrayList<String>();
    private ItemStack craftoutput = ItemStack.field_190927_a;
    private ResourceLocation background = null;
    private GuideLoader.ImageData image = null;
    private String linkback = "";
    private String linknext = "";
    private String text = "";
    private boolean validated = false;

    GuidePage() {
    }

    protected void setId(String id) {
        if (!this.validated) {
            this.id = id;
        }
    }

    protected void setTitle(String title) {
        if (!this.validated) {
            this.title = title;
        }
    }

    protected void setType(String type) {
        if (!this.validated) {
            this.type = EnumPageType.getType(type);
        }
    }

    void setLinkList(List<String> linklist) {
        this.linklist = linklist;
    }

    void setCraftOutput(@Nonnull ItemStack output) {
        this.craftoutput = output;
    }

    void setBackground(String file) {
        this.background = new ResourceLocation("shetiphianguide", file);
    }

    void setImage(GuideLoader.ImageData image) {
        this.image = image;
    }

    void setLinkBack(String linkback) {
        if (!this.validated) {
            this.linkback = linkback;
        }
    }

    void setLinkNext(String linknext) {
        if (!this.validated) {
            this.linknext = linknext;
        }
    }

    protected void setText(String text) {
        this.text = text = text.replace("<BR>", "\n").replace("<br>", "\n");
    }

    boolean validate() {
        boolean hasTitle;
        boolean hasId = !Strings.isNullOrEmpty((String)this.id);
        boolean bl = hasTitle = !Strings.isNullOrEmpty((String)this.title);
        if (!hasId || !hasTitle) {
            if (!hasId && hasTitle) {
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing 'id' [title: " + this.title + "]");
            } else if (hasId) {
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing 'title' [id: " + this.id + "]");
            } else {
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing 'id' and 'title'");
            }
            return false;
        }
        if (this.type == null) {
            ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing/invalid tag: 'type' [id:" + this.id + "]");
            return false;
        }
        switch (this.type) {
            case CRAFTING: 
            case SMELTING: {
                if (this.craftoutput != null) break;
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing/invalid tag: 'output' [id: " + this.id + "]");
                return false;
            }
            case TOC: {
                if (this.linklist != null && !this.linklist.isEmpty()) break;
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing/invalid tag: 'linklist' [id: " + this.id + "]");
                return false;
            }
            case TEXT: {
                break;
            }
            case CUSTOM: {
                if (this.background != null) break;
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing/invalid tag: 'background' [id: " + this.id + "]");
                return false;
            }
            case IMAGE: {
                if (this.image != null) break;
                ShetiPhianCore.LOGGER.error("Invalid GuidePage: missing/invalid tag: 'image' [id: " + this.id + "]");
                return false;
            }
        }
        this.validated = true;
        return true;
    }

    boolean hasLinkBack() {
        return !Strings.isNullOrEmpty((String)this.getLinkBack());
    }

    boolean hasLinkNext() {
        return !Strings.isNullOrEmpty((String)this.getLinkNext());
    }

    boolean hasText() {
        return !Strings.isNullOrEmpty((String)this.getText());
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public EnumPageType getType() {
        return this.type;
    }

    List<String> getLinkList() {
        return this.linklist;
    }

    @Nonnull
    ItemStack getCraftOutput() {
        return this.craftoutput;
    }

    ResourceLocation getBackground() {
        return this.background != null ? this.background : this.getType().getBackground();
    }

    GuideLoader.ImageData getImage() {
        return this.image;
    }

    String getLinkBack() {
        return this.linkback;
    }

    String getLinkNext() {
        return this.linknext;
    }

    public String getText() {
        return this.text;
    }

    static enum EnumPageType {
        TOC("gui/textpart.png"),
        TEXT("gui/textfull.png"),
        CRAFTING("gui/crafting.png"),
        SMELTING("gui/furnace.png"),
        IMAGE("gui/texthalf.png"),
        CUSTOM(null);

        private final ResourceLocation background;

        private EnumPageType(String file) {
            this.background = file != null ? new ResourceLocation("shetiphianguide", file) : null;
        }

        public ResourceLocation getBackground() {
            return this.background;
        }

        public static EnumPageType getType(String find) {
            find = find.toUpperCase().trim();
            for (EnumPageType type : EnumPageType.values()) {
                if (!type.name().equals(find)) continue;
                return type;
            }
            return TEXT;
        }
    }
}

