/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class BlockItemWithTooltip
extends BlockItem {
    private ITooltipPredicate tooltipPredicate;

    public BlockItemWithTooltip(Block block, Item.Properties builder, String tooltipKey) {
        this(block, builder, () -> (stack, world, tooltips, advanced) -> tooltips.add(new TranslationTextComponent(tooltipKey)));
    }

    public BlockItemWithTooltip(Block block, Item.Properties builder, Supplier<ITooltipPredicate> tooltipPredicate) {
        super(block, builder);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$null$2((Supplier)tooltipPredicate));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        if (this.tooltipPredicate != null) {
            this.tooltipPredicate.test(stack, world, tooltip, tooltipFlag.func_194127_a());
        }
    }

    private /* synthetic */ void lambda$null$2(Supplier tooltipPredicate) {
        this.tooltipPredicate = (ITooltipPredicate)tooltipPredicate.get();
    }

    public static interface ITooltipPredicate {
        public void test(ItemStack var1, World var2, List<ITextComponent> var3, Boolean var4);
    }
}

