/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import slimeknights.mantle.util.JsonHelper;

public class SizedIngredient
implements Predicate<ItemStack> {
    public static final SizedIngredient EMPTY = SizedIngredient.of(Ingredient.field_193370_a, 0);
    private final Ingredient ingredient;
    private final int amountNeeded;
    private WeakReference<ItemStack[]> lastIngredientMatch;
    private List<ItemStack> matchingStacks;

    public static SizedIngredient of(Ingredient ingredient) {
        return SizedIngredient.of(ingredient, 1);
    }

    public static SizedIngredient fromItems(int amountNeeded, IItemProvider ... items) {
        return SizedIngredient.of(Ingredient.func_199804_a((IItemProvider[])items), amountNeeded);
    }

    public static SizedIngredient fromItems(IItemProvider ... items) {
        return SizedIngredient.fromItems(1, items);
    }

    public static SizedIngredient fromTag(ITag<Item> tag, int amountNeeded) {
        return SizedIngredient.of(Ingredient.func_199805_a(tag), amountNeeded);
    }

    public static SizedIngredient fromTag(ITag<Item> tag) {
        return SizedIngredient.fromTag(tag, 1);
    }

    @Override
    public boolean test(ItemStack stack) {
        return stack.func_190916_E() >= this.amountNeeded && this.ingredient.test(stack);
    }

    public boolean hasNoMatchingStacks() {
        return this.ingredient.func_203189_d();
    }

    public List<ItemStack> getMatchingStacks() {
        ItemStack[] ingredientMatch = this.ingredient.func_193365_a();
        if (this.matchingStacks == null || this.lastIngredientMatch.get() != ingredientMatch) {
            this.matchingStacks = Arrays.stream(ingredientMatch).map(stack -> {
                if (stack.func_190916_E() != this.amountNeeded) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(this.amountNeeded);
                }
                return stack;
            }).collect(Collectors.toList());
            this.lastIngredientMatch = new WeakReference<ItemStack[]>(ingredientMatch);
        }
        return this.matchingStacks;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.amountNeeded);
        this.ingredient.func_199564_a(buffer);
    }

    public JsonObject serialize() {
        JsonElement ingredient = this.ingredient.func_200304_c();
        JsonObject json = null;
        if (ingredient.isJsonObject() && ((json = ingredient.getAsJsonObject()).has("ingredient") || json.has("amount_needed"))) {
            json = null;
        }
        if (json == null) {
            json = new JsonObject();
            json.add("ingredient", ingredient);
        }
        if (this.amountNeeded != 1) {
            json.addProperty("amount_needed", (Number)this.amountNeeded);
        }
        return json;
    }

    public static SizedIngredient read(PacketBuffer buffer) {
        int amountNeeded = buffer.func_150792_a();
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        return SizedIngredient.of(ingredient, amountNeeded);
    }

    public static SizedIngredient deserialize(JsonObject json) {
        int amountNeeded = JSONUtils.func_151208_a((JsonObject)json, (String)"amount_needed", (int)1);
        Ingredient ingredient = json.has("ingredient") ? Ingredient.func_199802_a((JsonElement)JsonHelper.getElement(json, "ingredient")) : Ingredient.func_199802_a((JsonElement)json);
        return SizedIngredient.of(ingredient, amountNeeded);
    }

    private SizedIngredient(Ingredient ingredient, int amountNeeded) {
        this.ingredient = ingredient;
        this.amountNeeded = amountNeeded;
    }

    public static SizedIngredient of(Ingredient ingredient, int amountNeeded) {
        return new SizedIngredient(ingredient, amountNeeded);
    }

    public int getAmountNeeded() {
        return this.amountNeeded;
    }
}

