/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.panorama;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import shadows.menu.PackMenuClient;

public class VariedRenderSkyboxCube
extends RenderSkyboxCube {
    private final ResourceLocation[][] locations = new ResourceLocation[10][6];

    public VariedRenderSkyboxCube(ResourceLocation texture) {
        super(texture);
        for (int i = 0; i < 6; ++i) {
            this.locations[0][i] = new ResourceLocation(texture.func_110624_b(), texture.func_110623_a() + '_' + i + ".png");
        }
        for (int variation = 1; variation < 10; ++variation) {
            for (int i = 0; i < 6; ++i) {
                this.locations[variation][i] = new ResourceLocation(texture.func_110624_b(), texture.func_110623_a() + variation + '_' + i + ".png");
            }
        }
    }

    public void setVariation(int variation) {
        this.field_209143_a = this.locations[variation];
    }

    public CompletableFuture<Void> func_217617_a(TextureManager texMngr, Executor backgroundExecutor) {
        CompletableFuture[] completablefuture = new CompletableFuture[PackMenuClient.panoramaVariations * 6];
        for (int i = 0; i < PackMenuClient.panoramaVariations; ++i) {
            for (int j = 0; j < 6; ++j) {
                completablefuture[i * 6 + j] = texMngr.func_215268_a(this.locations[i][j], backgroundExecutor);
            }
        }
        return CompletableFuture.allOf(completablefuture);
    }
}

