/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.logo;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.util.Strings;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.buttons.AnchorPoint;
import shadows.placebo.config.Configuration;

public class Logo {
    protected ResourceLocation texture;
    protected final int xOff;
    protected final int yOff;
    protected final int width;
    protected final int height;
    protected final int texWidth;
    protected final int texHeight;
    protected final AnchorPoint anchor;

    public Logo(int xOff, int yOff, int width, int height, int texWidth, int texHeight, ResourceLocation texture, AnchorPoint anchor) {
        this.xOff = xOff;
        this.yOff = yOff;
        this.width = width;
        this.height = height;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.texture = texture;
        this.anchor = anchor;
    }

    public void draw(ExtendedMenuScreen screen, MatrixStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.texture);
        RenderSystem.disableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.func_227860_a_();
        stack.func_227861_a_((double)this.anchor.getX(screen), (double)this.anchor.getY(screen), 0.0);
        stack.func_227862_a_((float)this.width / (float)this.texWidth, (float)this.height / (float)this.texHeight, 1.0f);
        Screen.func_238463_a_((MatrixStack)stack, (int)this.xOff, (int)this.yOff, (float)0.0f, (float)0.0f, (int)this.texWidth, (int)this.texHeight, (int)this.texWidth, (int)this.texHeight);
        stack.func_227865_b_();
        RenderSystem.enableDepthTest();
    }

    @Nullable
    public static Logo read(Configuration cfg) {
        String tex = cfg.getString("Texture Path", "logo", "packmenu:textures/gui/logo.png", "The location of the logo texture.  Must be a png file.  Should contain the extension.");
        int xOff = cfg.getInt("X Offset", "logo", -650, -500000, 500000, "The X offset of the logo.");
        int yOff = cfg.getInt("Y Offset", "logo", 0, -500000, 500000, "The Y offset of the logo.");
        int width = cfg.getInt("Width", "logo", 100, 0, 500000, "The width of the logo.");
        int height = cfg.getInt("Height", "logo", 100, 0, 500000, "The height of the logo.");
        int texWidth = cfg.getInt("Texture Width", "logo", 300, 0, 500000, "The width of the logo's texture.");
        int texHeight = cfg.getInt("Texture Height", "logo", 300, 0, 500000, "The height of the logo's texture.");
        AnchorPoint anchor = AnchorPoint.valueOf(cfg.getString("Anchor Point", "logo", "DEFAULT_LOGO", "The anchor point of the logo.  The types of anchor points are available on the wiki."));
        if (Strings.isBlank((String)tex)) {
            return null;
        }
        return new Logo(xOff, yOff, width, height, texWidth, texHeight, new ResourceLocation(tex), anchor);
    }
}

