/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.buttons;

import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.realms.RealmsBridgeScreen;
import net.minecraft.util.Util;
import shadows.menu.PackMenuClient;
import shadows.menu.buttons.ActionInstance;
import shadows.menu.buttons.ScreenType;

public enum ButtonAction {
    CONNECT_TO_SERVER(ai -> {
        Minecraft mc = Minecraft.func_71410_x();
        ServerData data = ButtonAction.getOrCreateServerData((String)ai.getData());
        mc.func_147108_a((Screen)new ConnectingScreen(mc.field_71462_r, mc, data));
    }, j -> j.get("data").getAsString()),
    LOAD_WORLD(ai -> {}, j -> j.get("data").getAsString()),
    REALMS(ai -> {
        RealmsBridgeScreen realmsbridgescreen = new RealmsBridgeScreen();
        realmsbridgescreen.func_231394_a_(Minecraft.func_71410_x().field_71462_r);
    }, j -> null),
    RELOAD(ai -> {
        PackMenuClient.loadConfig();
        Minecraft.func_71410_x().func_213237_g();
    }, j -> null),
    OPEN_GUI(ai -> Minecraft.func_71410_x().func_147108_a(((ScreenType)ai.getData()).apply(Minecraft.func_71410_x().field_71462_r)), j -> ScreenType.valueOf(j.get("data").getAsString().toUpperCase(Locale.ROOT))),
    OPEN_URL(ai -> Util.func_110647_a().func_195642_a((URI)ai.getData()), j -> {
        try {
            return new URI(j.get("data").getAsString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }),
    QUIT(ai -> Minecraft.func_71410_x().func_71400_g(), j -> null),
    NONE(ai -> {}, j -> null);

    private Consumer<ActionInstance> action;
    private Function<JsonObject, Object> reader;

    private ButtonAction(Consumer<ActionInstance> action, Function<JsonObject, Object> reader) {
        this.action = action;
        this.reader = reader;
    }

    public void onPress(ActionInstance button) {
        this.action.accept(button);
    }

    public Object readData(JsonObject json) {
        return this.reader.apply(json);
    }

    public static ServerData getOrCreateServerData(String ip) {
        MultiplayerScreen scn = new MultiplayerScreen(Minecraft.func_71410_x().field_71462_r);
        scn.func_231158_b_(Minecraft.func_71410_x(), 0, 0);
        ServerList list = scn.func_146795_p();
        for (int i = 0; i < list.func_78856_c(); ++i) {
            ServerData data = list.func_78850_a(i);
            if (!data.field_78845_b.equals(ip)) continue;
            return data;
        }
        ServerData data = new ServerData("Packmenu Managed Server", ip, false);
        list.func_78849_a(data);
        list.func_78855_b();
        return data;
    }
}

