/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.PackMenu;
import shadows.menu.buttons.AnchorPoint;
import shadows.menu.logo.Logo;
import shadows.menu.panorama.VariedRenderSkyboxCube;
import shadows.menu.reload.ButtonManager;
import shadows.menu.reload.Supporters;
import shadows.menu.slideshow.Slideshow;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.RunnableReloader;

public class PackMenuClient {
    public static final File RESOURCE_PACK = new File(FMLPaths.GAMEDIR.get().toFile(), "packmenu/resources.zip");
    public static final File FOLDER_PACK = new File(FMLPaths.GAMEDIR.get().toFile(), "packmenu/resources");
    public static final ButtonManager BUTTON_MANAGER = new ButtonManager();
    public static final VariedRenderSkyboxCube PANORAMA_RESOURCES;
    public static boolean drawTitle;
    public static boolean drawSplash;
    public static boolean drawJavaEd;
    public static boolean drawForgeInfo;
    public static boolean drawPanorama;
    public static Offset title;
    public static Offset javaEd;
    public static Offset forgeWarn;
    public static Offset splash;
    public static boolean folderPack;
    public static float splashRotation;
    public static int splashColor;
    public static AnchorPoint splashAnchor;
    public static List<ResourceLocation> slideshowTextures;
    public static int slideshowDuration;
    public static int slideshowTransition;
    public static boolean slideshow;
    public static boolean panoramaFade;
    public static float panoramaSpeed;
    public static int panoramaVariations;
    public static String patreonUrl;
    public static Logo logo;

    public void load() {
        MinecraftForge.EVENT_BUS.addListener(this::hijackMenu);
        PackMenuClient.loadConfig();
        if (!folderPack && !RESOURCE_PACK.exists()) {
            try (InputStream stream = this.getClass().getResourceAsStream("/resources.zip");){
                RESOURCE_PACK.getParentFile().mkdir();
                RESOURCE_PACK.createNewFile();
                byte[] buffer = new byte[600000];
                FileOutputStream outStream = new FileOutputStream(RESOURCE_PACK);
                int i = 0;
                while ((i = stream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, i);
                }
                outStream.close();
            }
            catch (IOException e) {
                PackMenu.LOGGER.error("Failed to copy default resouces into the game directory!");
            }
        } else if (folderPack && !FOLDER_PACK.exists()) {
            try (InputStream stream = this.getClass().getResourceAsStream("/resources.zip");){
                boolean existed = RESOURCE_PACK.exists();
                if (!existed) {
                    RESOURCE_PACK.getParentFile().mkdir();
                    RESOURCE_PACK.createNewFile();
                    byte[] buffer = new byte[600000];
                    FileOutputStream outStream = new FileOutputStream(RESOURCE_PACK);
                    int i = 0;
                    while ((i = stream.read(buffer)) != -1) {
                        outStream.write(buffer, 0, i);
                    }
                    outStream.close();
                }
                FOLDER_PACK.mkdir();
                try (ZipFile zipFile = new ZipFile(RESOURCE_PACK);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        File entryDestination = new File(FOLDER_PACK, entry.getName());
                        if (entry.isDirectory()) {
                            entryDestination.mkdirs();
                            continue;
                        }
                        entryDestination.getParentFile().mkdirs();
                        InputStream in = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            FileOutputStream out = new FileOutputStream(entryDestination);
                            Throwable throwable2 = null;
                            try {
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (out == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)out).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((OutputStream)out).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                }
                catch (IOException e) {
                    PackMenu.LOGGER.error("Failed to unzip default resouces into the game directory!");
                }
                if (!existed) {
                    RESOURCE_PACK.delete();
                }
            }
            catch (IOException e) {
                PackMenu.LOGGER.error("Failed to copy default resouces into the game directory!");
            }
        }
        Minecraft.func_71410_x().func_195548_H().addPackFinder(new IPackFinder(){

            public void func_230230_a_(Consumer<ResourcePackInfo> map, ResourcePackInfo.IFactory factory) {
                ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)"packmenu", (boolean)true, () -> folderPack ? new FolderPack(FOLDER_PACK) : new FilePack(RESOURCE_PACK), (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
                if (packInfo == null) {
                    PackMenu.LOGGER.error("Failed to load resource pack, some things may not work.");
                    return;
                }
                map.accept(packInfo);
            }
        });
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)BUTTON_MANAGER);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new RunnableReloader(() -> {
            int var = ThreadLocalRandom.current().nextInt(panoramaVariations);
            PANORAMA_RESOURCES.setVariation(var);
        }));
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)Supporters.INSTANCE);
    }

    @SubscribeEvent
    public void hijackMenu(GuiOpenEvent e) {
        if (e.getGui() != null && e.getGui().getClass() == MainMenuScreen.class) {
            e.setGui((Screen)new ExtendedMenuScreen(panoramaFade));
        }
    }

    public static void loadConfig() {
        Configuration cfg = new Configuration("packmenu");
        drawTitle = cfg.getBoolean("Draw Title", "general", true, "If the title (the giant minecraft text) is drawn.");
        drawSplash = cfg.getBoolean("Draw Splash", "general", true, "If the splash text is drawn.");
        drawJavaEd = cfg.getBoolean("Draw Java Edition", "general", true, "If the \"Java Edition\" text is drawn.");
        drawForgeInfo = cfg.getBoolean("Draw Forge Info", "general", true, "If forge information is drawn at the top center.  This includes beta and update warnings.");
        drawPanorama = cfg.getBoolean("Draw Panorama", "general", false, "If the vanilla panorama, and it's fade-in, are rendered.  Enabling this disables the use of the custom background options.");
        title = PackMenuClient.getOffset("Title", AnchorPoint.TITLE, cfg);
        javaEd = PackMenuClient.getOffset("Java Edition Text", AnchorPoint.JAVAED, cfg);
        forgeWarn = PackMenuClient.getOffset("Forge Info", AnchorPoint.FORGE, cfg);
        splash = PackMenuClient.getOffset("Splash Text", AnchorPoint.SPLASH, cfg);
        splashRotation = cfg.getFloat("Rotation", "splash text", splashRotation, -360.0f, 360.0f, "The rotation value of the splash text.");
        splashColor = cfg.getInt("Color", "splash text", splashColor, -2147483647, Integer.MAX_VALUE, "The color of the splash text.");
        folderPack = cfg.getBoolean("Folder Pack", "general", true, "If the resource pack is loaded from /resources instead of /resources.zip");
        logo = Logo.read(cfg);
        String[] slideshow = cfg.getStringList("Textures", "slideshow", new String[0], "The list of textures to be displayed on the slideshow.  If empty, the slideshow is ignored.");
        slideshowTextures = new ArrayList<ResourceLocation>();
        for (String s : slideshow) {
            try {
                slideshowTextures.add(new ResourceLocation(s));
            }
            catch (ResourceLocationException e) {
                e.printStackTrace();
            }
        }
        slideshowDuration = cfg.getInt("Duration", "slideshow", 200, 1, 1000000, "How long between slideshow transitions.");
        slideshowTransition = cfg.getInt("Transition Duration", "slideshow", 20, 1, 1000000, "How long the slideshow transition lasts.");
        panoramaFade = cfg.getBoolean("Panorama Fade In", "general", panoramaFade, "If the Panorama has a fade-in effect.");
        panoramaSpeed = cfg.getFloat("Panorama Speed", "general", 1.0f, 0.01f, 100.0f, "A multiplier on panorama speed.");
        panoramaVariations = cfg.getInt("Panorama Variations", "general", panoramaVariations, 1, 10, "The number of variations of panorama that exist.  Panorama files other than the original set must have the form panorama<y>_<z>.png.  For example the first file of varation #2 would be panorama1_0.png");
        PackMenuClient.slideshow = !slideshowTextures.isEmpty();
        Slideshow.reset();
        patreonUrl = cfg.getString("Patreon Url", "support", patreonUrl, "The URL that the link on the supporters page goes to.");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static Offset getOffset(String key, AnchorPoint def, Configuration cfg) {
        AnchorPoint anchor = AnchorPoint.valueOf(cfg.getString("Anchor Point", key, def.toString(), "The anchor point for this element."));
        int x = cfg.getInt("X Offset", key, 0, -1000, 1000, "The X offset for this element.");
        int y = cfg.getInt("Y Offset", key, 0, -1000, 1000, "The Y Offset for this element.");
        return new Offset(anchor, x, y);
    }

    static {
        MainMenuScreen.field_213098_a = new VariedRenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama"));
        PANORAMA_RESOURCES = (VariedRenderSkyboxCube)MainMenuScreen.field_213098_a;
        drawTitle = true;
        drawSplash = true;
        drawJavaEd = true;
        drawForgeInfo = true;
        drawPanorama = false;
        folderPack = false;
        splashRotation = -20.0f;
        splashColor = -256;
        splashAnchor = AnchorPoint.MIDDLE_CENTER;
        slideshowDuration = 200;
        slideshowTransition = 20;
        slideshow = false;
        panoramaFade = false;
        panoramaSpeed = 1.0f;
        panoramaVariations = 1;
        patreonUrl = "https://www.patreon.com/Shadows_of_Fire?fan_landing=true";
        logo = null;
    }

    public static class Offset {
        public final AnchorPoint anchor;
        public final int x;
        public final int y;

        public Offset(AnchorPoint anchor, int x, int y) {
            this.anchor = anchor;
            this.x = x;
            this.y = y;
        }

        public int getX(ExtendedMenuScreen scn) {
            return this.anchor.getX(scn) + this.x;
        }

        public int getY(ExtendedMenuScreen scn) {
            return this.anchor.getY(scn) + this.y;
        }
    }
}

