/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.screen.grid.stack.FluidGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StackUtils {
    public static final ItemStack EMPTY_BUCKET = new ItemStack((IItemProvider)Items.field_151133_ar);
    private static final String NBT_INVENTORY = "Inventory_%d";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_FORGE_CAPS = "ForgeCaps";
    private static final Logger LOGGER = LogManager.getLogger(StackUtils.class);
    private static final String NBT_ITEM_ID = "Id";
    private static final String NBT_ITEM_QUANTITY = "Quantity";
    private static final String NBT_ITEM_NBT = "NBT";
    private static final String NBT_ITEM_CAPS = "Caps";

    private StackUtils() {
    }

    public static void writeItemStack(PacketBuffer buf, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            Item item = stack.func_77973_b();
            buf.func_150787_b(Item.func_150891_b((Item)item));
            buf.writeInt(stack.func_190916_E());
            CompoundNBT tag = null;
            if (item.func_77645_m() || item.func_77651_p()) {
                tag = stack.func_77978_p();
            }
            buf.func_150786_a(tag);
        }
    }

    public static ItemStack readItemStack(PacketBuffer buf) {
        if (!buf.readBoolean()) {
            return ItemStack.field_190927_a;
        }
        int id = buf.func_150792_a();
        int count = buf.readInt();
        ItemStack stack = new ItemStack((IItemProvider)Item.func_150899_d((int)id), count);
        stack.readShareTag(buf.func_150793_b());
        return stack;
    }

    public static void writeItemGridStack(PacketBuffer buf, ItemStack stack, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        StackUtils.writeItemStack(buf, stack);
        buf.writeBoolean(craftable);
        buf.func_179252_a(id);
        buf.writeBoolean(otherId != null);
        if (otherId != null) {
            buf.func_179252_a(otherId);
        }
        if (entry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(entry.getTime());
            buf.func_180714_a(entry.getName());
        }
    }

    public static ItemGridStack readItemGridStack(PacketBuffer buf) {
        ItemStack stack = StackUtils.readItemStack(buf);
        boolean craftable = buf.readBoolean();
        UUID id = buf.func_179253_g();
        UUID otherId = null;
        if (buf.readBoolean()) {
            otherId = buf.func_179253_g();
        }
        StorageTrackerEntry entry = null;
        if (buf.readBoolean()) {
            entry = new StorageTrackerEntry(buf.readLong(), PacketBufferUtils.readString(buf));
        }
        return new ItemGridStack(id, otherId, stack, craftable, entry);
    }

    public static void writeFluidGridStack(PacketBuffer buf, FluidStack stack, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        stack.writeToPacket(buf);
        buf.writeBoolean(craftable);
        buf.func_179252_a(id);
        buf.writeBoolean(otherId != null);
        if (otherId != null) {
            buf.func_179252_a(otherId);
        }
        if (entry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(entry.getTime());
            buf.func_180714_a(entry.getName());
        }
    }

    public static FluidGridStack readFluidGridStack(PacketBuffer buf) {
        FluidStack stack = FluidStack.readFromPacket((PacketBuffer)buf);
        boolean craftable = buf.readBoolean();
        UUID id = buf.func_179253_g();
        UUID otherId = null;
        if (buf.readBoolean()) {
            otherId = buf.func_179253_g();
        }
        StorageTrackerEntry entry = null;
        if (buf.readBoolean()) {
            entry = new StorageTrackerEntry(buf.readLong(), PacketBufferUtils.readString(buf));
        }
        return new FluidGridStack(id, otherId, stack, entry, craftable);
    }

    public static void createStorages(ServerWorld world, ItemStack diskStack, int slot, IStorageDisk<ItemStack>[] itemDisks, IStorageDisk<FluidStack>[] fluidDisks, Function<IStorageDisk<ItemStack>, IStorageDisk> itemDiskWrapper, Function<IStorageDisk<FluidStack>, IStorageDisk> fluidDiskWrapper) {
        if (diskStack.func_190926_b()) {
            itemDisks[slot] = null;
            fluidDisks[slot] = null;
        } else {
            IStorageDisk disk = API.instance().getStorageDiskManager(world).getByStack(diskStack);
            if (disk != null) {
                StorageType type = ((IStorageDiskProvider)diskStack.func_77973_b()).getType();
                if (type == StorageType.ITEM) {
                    itemDisks[slot] = itemDiskWrapper.apply(disk);
                } else if (type == StorageType.FLUID) {
                    fluidDisks[slot] = fluidDiskWrapper.apply(disk);
                }
            } else {
                itemDisks[slot] = null;
                fluidDisks[slot] = null;
            }
        }
    }

    public static void writeItems(IItemHandler handler, int id, CompoundNBT tag, Function<ItemStack, CompoundNBT> serializer) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            CompoundNBT stackTag = serializer.apply(handler.getStackInSlot(i));
            stackTag.func_74768_a(NBT_SLOT, i);
            tagList.add((Object)stackTag);
        }
        tag.func_218657_a(String.format(NBT_INVENTORY, id), (INBT)tagList);
    }

    public static void writeItems(IItemHandler handler, int id, CompoundNBT tag) {
        StackUtils.writeItems(handler, id, tag, stack -> stack.func_77955_b(new CompoundNBT()));
    }

    public static void readItems(IItemHandlerModifiable handler, int id, CompoundNBT tag, Function<CompoundNBT, ItemStack> deserializer) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            ListNBT tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, deserializer.apply(tagList.func_150305_b(i)));
            }
        }
    }

    public static void readItems(IItemHandlerModifiable handler, int id, CompoundNBT tag) {
        StackUtils.readItems(handler, id, tag, ItemStack::func_199557_a);
    }

    public static void readItems(BaseItemHandler handler, int id, CompoundNBT tag) {
        handler.setReading(true);
        StackUtils.readItems((IItemHandlerModifiable)handler, id, tag, ItemStack::func_199557_a);
        handler.setReading(false);
    }

    public static void writeItems(IInventory inventory, int id, CompoundNBT tag) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74768_a(NBT_SLOT, i);
            inventory.func_70301_a(i).func_77955_b(stackTag);
            tagList.add((Object)stackTag);
        }
        tag.func_218657_a(String.format(NBT_INVENTORY, id), (INBT)tagList);
    }

    public static void readItems(IInventory inventory, int id, CompoundNBT tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            ListNBT tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tagList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    public static FluidStack copy(FluidStack stack, int size) {
        FluidStack copy = stack.copy();
        copy.setAmount(size);
        return copy;
    }

    public static FluidStack copy(@Nullable FluidStack stack) {
        return stack == null ? null : stack.copy();
    }

    public static Pair<ItemStack, FluidStack> getFluid(ItemStack stack, boolean simulate) {
        IFluidHandlerItem handler;
        if (stack.func_190926_b()) {
            return Pair.of((Object)ItemStack.field_190927_a, (Object)FluidStack.EMPTY);
        }
        if (stack.func_190916_E() > 1) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        if ((handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null)) != null) {
            FluidStack result = handler.drain(1000, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            return Pair.of((Object)handler.getContainer(), (Object)result);
        }
        return Pair.of((Object)ItemStack.field_190927_a, (Object)FluidStack.EMPTY);
    }

    public static CompoundNBT serializeStackToNbt(@Nonnull ItemStack stack) {
        CompoundNBT dummy = new CompoundNBT();
        CompoundNBT itemTag = new CompoundNBT();
        itemTag.func_74778_a(NBT_ITEM_ID, stack.func_77973_b().getRegistryName().toString());
        itemTag.func_74768_a(NBT_ITEM_QUANTITY, stack.func_190916_E());
        if (stack.func_77942_o()) {
            itemTag.func_218657_a(NBT_ITEM_NBT, (INBT)stack.func_77978_p());
        }
        stack.func_77955_b(dummy);
        if (dummy.func_74764_b(NBT_FORGE_CAPS)) {
            itemTag.func_218657_a(NBT_ITEM_CAPS, dummy.func_74781_a(NBT_FORGE_CAPS));
        }
        dummy.func_82580_o(NBT_FORGE_CAPS);
        return itemTag;
    }

    @Nonnull
    public static ItemStack deserializeStackFromNbt(CompoundNBT tag) {
        Item item;
        if (tag.func_74764_b(NBT_ITEM_ID)) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i(NBT_ITEM_ID)));
            if (item == null) {
                LOGGER.warn("Could not deserialize item from string ID {}, it no longer exists", (Object)tag.func_74779_i(NBT_ITEM_ID));
            }
        } else {
            throw new IllegalStateException("Cannot deserialize ItemStack: no Id tag was found!");
        }
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)item, tag.func_74762_e(NBT_ITEM_QUANTITY), tag.func_74764_b(NBT_ITEM_CAPS) ? tag.func_74775_l(NBT_ITEM_CAPS) : null);
        stack.func_77982_d(tag.func_74764_b(NBT_ITEM_NBT) ? tag.func_74775_l(NBT_ITEM_NBT) : null);
        return stack;
    }
}

