/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.widget.sidebutton;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.integration.inventorytweaks.InventoryTweaksIntegration;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GridSortingTypeSideButton
extends SideButton {
    private final IGrid grid;

    public GridSortingTypeSideButton(BaseScreen<GridContainer> screen, IGrid grid) {
        super(screen);
        this.grid = grid;
    }

    @Override
    public String getTooltip() {
        return I18n.func_135052_a((String)"sidebutton.refinedstorage.grid.sorting.type", (Object[])new Object[0]) + "\n" + TextFormatting.GRAY + I18n.func_135052_a((String)("sidebutton.refinedstorage.grid.sorting.type." + this.grid.getSortingType()), (Object[])new Object[0]);
    }

    @Override
    protected void renderButtonIcon(MatrixStack matrixStack, int x, int y) {
        if (this.grid.getSortingType() == 4) {
            this.screen.func_238474_b_(matrixStack, x, y, 48, 48, 16, 16);
        } else {
            this.screen.func_238474_b_(matrixStack, x, y, this.grid.getSortingType() * 16, 32, 16, 16);
        }
    }

    public void func_230930_b_() {
        int type = this.grid.getSortingType();
        if (type == 0) {
            type = 1;
        } else if (type == 1) {
            type = this.grid.getGridType() == GridType.FLUID ? 4 : 2;
        } else if (type == 2) {
            type = 4;
        } else if (type == 4) {
            type = this.grid.getGridType() == GridType.FLUID || !InventoryTweaksIntegration.isLoaded() ? 0 : 3;
        } else if (type == 3) {
            type = 0;
        }
        this.grid.onSortingTypeChanged(type);
    }
}

