/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.FluidCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ItemCraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.render.CraftingPreviewElementDrawers;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartRequestMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPreviewScreen
extends BaseScreen<Container> {
    private static final int VISIBLE_ROWS = 5;
    private final List<ICraftingPreviewElement> elements;
    private final Screen parent;
    private final ScrollbarWidget scrollbar;
    private final UUID id;
    private final int quantity;
    private final boolean fluids;
    private ItemStack hoveringStack;
    private FluidStack hoveringFluid;
    private final IElementDrawers drawers = new CraftingPreviewElementDrawers(this);

    public CraftingPreviewScreen(Screen parent, List<ICraftingPreviewElement> elements, UUID id, int quantity, boolean fluids, ITextComponent title) {
        super(new Container(null, 0){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        }, 254, 201, null, title);
        this.elements = new ArrayList<ICraftingPreviewElement>(elements);
        this.parent = parent;
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
        this.scrollbar = new ScrollbarWidget(this, 235, 20, 12, 149);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addButton(x + 55, y + 201 - 20 - 7, 50, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), true, true, btn -> this.close());
        Button startButton = this.addButton(x + 129, y + 201 - 20 - 7, 50, 20, (ITextComponent)new TranslationTextComponent("misc.refinedstorage.start"), true, true, btn -> this.startRequest());
        startButton.field_230693_o_ = this.elements.stream().noneMatch(ICraftingPreviewElement::doesDisableTaskStarting);
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 5);
        this.scrollbar.setMaxOffset(this.getRows() - 5);
    }

    @Nullable
    private ErrorCraftingPreviewElement getError() {
        if (this.elements.size() == 1 && this.elements.get(0) instanceof ErrorCraftingPreviewElement) {
            return (ErrorCraftingPreviewElement)this.elements.get(0);
        }
        return null;
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/crafting_preview.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.getError() != null) {
            CraftingPreviewScreen.func_238467_a_((MatrixStack)matrixStack, (int)(x + 7), (int)(y + 20), (int)(x + 228), (int)(y + 169), (int)-2368549);
        }
        this.scrollbar.render(matrixStack);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        int x = 7;
        int y = 15;
        float scale = Minecraft.func_71410_x().func_211821_e() ? 1.0f : 0.5f;
        ErrorCraftingPreviewElement error = this.getError();
        if (error != null) {
            this.renderError(matrixStack, x, y, scale, error);
        } else {
            this.renderPreview(matrixStack, mouseX, mouseY, x, y);
        }
    }

    private void renderPreview(MatrixStack matrixStack, int mouseX, int mouseY, int x, int y) {
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
        RenderHelper.func_227784_d_();
        RenderSystem.enableDepthTest();
        this.hoveringStack = null;
        this.hoveringFluid = null;
        for (int i = 0; i < 15; ++i) {
            if (slot < this.elements.size()) {
                this.renderElement(matrixStack, mouseX, mouseY, x, y, this.elements.get(slot));
            }
            if ((i + 1) % 3 == 0) {
                x = 7;
                y += 30;
            } else {
                x += 74;
            }
            ++slot;
        }
    }

    private void renderElement(MatrixStack matrixStack, int mouseX, int mouseY, int x, int y, ICraftingPreviewElement element) {
        element.draw(matrixStack, x, y + 5, this.drawers);
        if (RenderUtils.inBounds(x + 5, y + 7, 16, 16, mouseX, mouseY)) {
            ItemStack itemStack = this.hoveringStack = element instanceof ItemCraftingPreviewElement ? ((ItemCraftingPreviewElement)element).getStack() : null;
            if (this.hoveringStack == null) {
                this.hoveringFluid = element instanceof FluidCraftingPreviewElement ? ((FluidCraftingPreviewElement)element).getStack() : null;
            }
        }
    }

    private void renderError(MatrixStack matrixStack, int x, int y, float scale, ErrorCraftingPreviewElement errorElement) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 11, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error", (Object[])new Object[0]));
        switch (errorElement.getType()) {
            case RECURSIVE: {
                this.renderRecursiveError(matrixStack, x, y, scale, errorElement.getRecursedPattern());
                break;
            }
            case TOO_COMPLEX: {
                this.renderTooComplexError(matrixStack, x, y, scale);
                break;
            }
        }
        matrixStack.func_227865_b_();
    }

    private void renderTooComplexError(MatrixStack matrixStack, int x, int y, float scale) {
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.too_complex.0", (Object[])new Object[0]));
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.too_complex.1", (Object[])new Object[0]));
    }

    private void renderRecursiveError(MatrixStack matrixStack, int x, int y, float scale, ItemStack recursedPattern) {
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 21, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.0", (Object[])new Object[0]));
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 31, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.1", (Object[])new Object[0]));
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 41, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.2", (Object[])new Object[0]));
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 51, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.3", (Object[])new Object[0]));
        this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 61, scale), I18n.func_135052_a((String)"gui.refinedstorage.crafting_preview.error.recursive.4", (Object[])new Object[0]));
        ICraftingPattern pattern = PatternItem.fromCache((World)this.parent.getMinecraft().field_71441_e, recursedPattern);
        int yy = 83;
        for (ItemStack output : pattern.getOutputs()) {
            if (output == null) continue;
            this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 25, scale), RenderUtils.getOffsetOnScale(yy + 6, scale), output.func_200301_q().getString());
            RenderHelper.func_227784_d_();
            RenderSystem.enableDepthTest();
            this.renderItem(matrixStack, x + 5, yy, output);
            RenderHelper.func_74518_a();
            yy += 17;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.hoveringStack != null) {
            this.renderTooltip(matrixStack, this.hoveringStack, mouseX, mouseY, this.hoveringStack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        } else if (this.hoveringFluid != null) {
            this.renderTooltip(matrixStack, mouseX, mouseY, this.hoveringFluid.getDisplayName().getString());
        }
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean func_231044_a_(double mx, double my, int button) {
        return this.scrollbar.func_231044_a_(mx, my, button) || super.func_231044_a_(mx, my, button);
    }

    public boolean func_231048_c_(double mx, double my, int button) {
        return this.scrollbar.func_231048_c_(mx, my, button) || super.func_231048_c_(mx, my, button);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        return this.scrollbar.func_231043_a_(x, y, delta) || super.func_231043_a_(x, y, delta);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 257 || key == 335) {
            this.startRequest();
            return true;
        }
        if (key == 256) {
            this.close();
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    private void startRequest() {
        RS.NETWORK_HANDLER.sendToServer(new GridCraftingStartRequestMessage(this.id, this.quantity, this.fluids));
        this.close();
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.elements.size() / 3.0f));
    }

    private void close() {
        this.field_230706_i_.func_147108_a(this.parent);
    }
}

