/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.FilterContainer;
import com.refinedmods.refinedstorage.item.FilterItem;
import com.refinedmods.refinedstorage.network.FilterUpdateMessage;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.FilterTypeSideButton;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FilterScreen
extends BaseScreen<FilterContainer> {
    private final ItemStack stack;
    private int compare;
    private int mode;
    private boolean modFilter;
    private final String name;
    private int type;
    private CheckboxWidget modFilterCheckBox;
    private Button modeButton;
    private TextFieldWidget nameField;

    public FilterScreen(FilterContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 176, 231, inventory, title);
        this.stack = container.getFilterItem();
        this.compare = FilterItem.getCompare(container.getFilterItem());
        this.mode = FilterItem.getMode(container.getFilterItem());
        this.modFilter = FilterItem.isModFilter(container.getFilterItem());
        this.name = FilterItem.getName(container.getFilterItem());
        this.type = FilterItem.getType(container.getFilterItem());
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addCheckBox(x + 7, y + 77, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.filter.compare_nbt"), (this.compare & 1) == 1, btn -> {
            this.compare ^= 1;
            this.sendUpdate();
        });
        this.modFilterCheckBox = this.addCheckBox(0, y + 71 + 25, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.filter.mod_filter"), this.modFilter, btn -> {
            this.modFilter = !this.modFilter;
            this.sendUpdate();
        });
        this.modeButton = this.addButton(x + 7, y + 71 + 21, 0, 20, (ITextComponent)new StringTextComponent(""), true, true, btn -> {
            this.mode = this.mode == 0 ? 1 : 0;
            this.updateModeButton(this.mode);
            this.sendUpdate();
        });
        this.updateModeButton(this.mode);
        this.field_230712_o_.getClass();
        this.nameField = new TextFieldWidget(this.field_230712_o_, x + 34, y + 121, 131, 9, (ITextComponent)new StringTextComponent(""));
        this.nameField.func_146180_a(this.name);
        this.nameField.func_146185_a(false);
        this.nameField.func_146189_e(true);
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.nameField.func_146193_g(RenderSettings.INSTANCE.getSecondaryColor());
        this.nameField.func_212954_a(content -> this.sendUpdate());
        this.func_230480_a_((Widget)this.nameField);
        this.addSideButton(new FilterTypeSideButton(this));
    }

    private void updateModeButton(int mode) {
        TranslationTextComponent text = mode == 0 ? new TranslationTextComponent("sidebutton.refinedstorage.mode.whitelist") : new TranslationTextComponent("sidebutton.refinedstorage.mode.blacklist");
        this.modeButton.func_230991_b_(this.field_230712_o_.func_78256_a(text.getString()) + 12);
        this.modeButton.func_238482_a_((ITextComponent)text);
        this.modFilterCheckBox.field_230690_l_ = this.modeButton.field_230690_l_ + this.modeButton.func_230998_h_() + 4;
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        if (this.nameField.func_231046_a_(key, scanCode, modifiers) || this.nameField.func_212955_f()) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/filter.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, 137, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        FilterItem.setType(this.stack, type);
    }

    public void sendUpdate() {
        RS.NETWORK_HANDLER.sendToServer(new FilterUpdateMessage(this.compare, this.mode, this.modFilter, this.nameField.func_146179_b(), this.type));
    }
}

