/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class CubeBuilder {
    private Vector3f from;
    private Vector3f to;
    private VertexFormat format = DefaultVertexFormats.field_176600_a;
    private Map<Direction, Face> faces = new HashMap<Direction, Face>();
    private int color = -1;

    public CubeBuilder from(float x, float y, float z) {
        this.from = new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f);
        return this;
    }

    public CubeBuilder to(float x, float y, float z) {
        this.to = new Vector3f(x / 16.0f, y / 16.0f, z / 16.0f);
        return this;
    }

    public CubeBuilder color(int color) {
        this.color = color;
        return this;
    }

    public CubeBuilder lightmap() {
        this.format = RenderUtils.getFormatWithLightMap(this.format);
        return this;
    }

    public CubeBuilder addFaces(Function<Direction, Face> faceSupplier) {
        for (Direction facing : Direction.values()) {
            this.addFace(faceSupplier.apply(facing));
        }
        return this;
    }

    public CubeBuilder addFace(Face face) {
        this.faces.put(face.face, face);
        return this;
    }

    public List<BakedQuad> bake() {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry<Direction, Face> entry : this.faces.entrySet()) {
            quads.add(this.bakeFace(entry.getKey(), entry.getValue()));
        }
        return quads;
    }

    private BakedQuad bakeFace(Direction facing, Face cubeFace) {
        BakedQuadBuilder builder = new BakedQuadBuilder(cubeFace.sprite);
        builder.setQuadOrientation(facing);
        builder.setQuadTint(-1);
        builder.setApplyDiffuseLighting(true);
        Uv uv = this.getDefaultUv(facing, cubeFace.sprite, this.from.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), this.to.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c());
        switch (facing) {
            case DOWN: {
                this.addVertexTopRight(builder, cubeFace, this.to.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.func_195899_a(), this.from.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.func_195899_a(), this.from.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), uv);
                break;
            }
            case UP: {
                this.addVertexTopLeft(builder, cubeFace, this.from.func_195899_a(), this.to.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.func_195899_a(), this.to.func_195900_b(), this.from.func_195902_c(), uv);
                break;
            }
            case NORTH: {
                this.addVertexBottomRight(builder, cubeFace, this.to.func_195899_a(), this.to.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.func_195899_a(), this.to.func_195900_b(), this.from.func_195902_c(), uv);
                break;
            }
            case SOUTH: {
                this.addVertexBottomLeft(builder, cubeFace, this.from.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.from.func_195899_a(), this.from.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.func_195899_a(), this.from.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.to.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c(), uv);
                break;
            }
            case WEST: {
                this.addVertexTopLeft(builder, cubeFace, this.from.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexTopRight(builder, cubeFace, this.from.func_195899_a(), this.from.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexBottomRight(builder, cubeFace, this.from.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.from.func_195899_a(), this.to.func_195900_b(), this.from.func_195902_c(), uv);
                break;
            }
            case EAST: {
                this.addVertexBottomRight(builder, cubeFace, this.to.func_195899_a(), this.to.func_195900_b(), this.from.func_195902_c(), uv);
                this.addVertexBottomLeft(builder, cubeFace, this.to.func_195899_a(), this.to.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexTopLeft(builder, cubeFace, this.to.func_195899_a(), this.from.func_195900_b(), this.to.func_195902_c(), uv);
                this.addVertexTopRight(builder, cubeFace, this.to.func_195899_a(), this.from.func_195900_b(), this.from.func_195902_c(), uv);
            }
        }
        return builder.build();
    }

    private Uv getDefaultUv(Direction face, TextureAtlasSprite texture, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        Uv uv = new Uv();
        switch (face) {
            case DOWN: {
                uv.xFrom = texture.func_94214_a((double)(fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromZ * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toZ * 16.0f));
                break;
            }
            case UP: {
                uv.xFrom = texture.func_94214_a((double)(fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(fromZ * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(toZ * 16.0f));
                break;
            }
            case NORTH: {
                uv.xFrom = texture.func_94214_a((double)(16.0f - fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(16.0f - toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
                break;
            }
            case SOUTH: {
                uv.xFrom = texture.func_94214_a((double)(fromX * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toX * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
                break;
            }
            case WEST: {
                uv.xFrom = texture.func_94214_a((double)(fromZ * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(toZ * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
                break;
            }
            case EAST: {
                uv.xFrom = texture.func_94214_a((double)(16.0f - toZ * 16.0f));
                uv.yFrom = texture.func_94207_b((double)(16.0f - fromY * 16.0f));
                uv.xTo = texture.func_94214_a((double)(16.0f - fromZ * 16.0f));
                uv.yTo = texture.func_94207_b((double)(16.0f - toY * 16.0f));
            }
        }
        return uv;
    }

    private void addVertexTopLeft(BakedQuadBuilder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xFrom;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xFrom;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xTo;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xTo;
                v = uv.yFrom;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertexTopRight(BakedQuadBuilder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xTo;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xFrom;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xFrom;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xTo;
                v = uv.yTo;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertexBottomRight(BakedQuadBuilder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xTo;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xTo;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xFrom;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xFrom;
                v = uv.yTo;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertexBottomLeft(BakedQuadBuilder builder, Face face, float x, float y, float z, Uv uv) {
        float v;
        float u;
        switch (face.uvRotation) {
            default: {
                u = uv.xFrom;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_90: {
                u = uv.xTo;
                v = uv.yTo;
                break;
            }
            case CLOCKWISE_180: {
                u = uv.xTo;
                v = uv.yFrom;
                break;
            }
            case CLOCKWISE_270: {
                u = uv.xFrom;
                v = uv.yFrom;
            }
        }
        this.addVertex(builder, face, x, y, z, u, v);
    }

    private void addVertex(BakedQuadBuilder builder, Face face, float x, float y, float z, float u, float v) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int i = 0; i < format.func_227894_c_().size(); ++i) {
            VertexFormatElement e = (VertexFormatElement)format.func_227894_c_().get(i);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(i, new float[]{x, y, z});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(i, new float[]{face.face.func_82601_c(), face.face.func_96559_d(), face.face.func_82599_e()});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(this.color & 0xFF) / 255.0f;
                    float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
                    builder.put(i, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (e.func_177369_e() == 0) {
                        builder.put(i, new float[]{u, v});
                        continue block6;
                    }
                    builder.put(i, new float[]{(float)(face.light * 32) / 65535.0f, (float)(face.light * 32) / 65535.0f});
                    continue block6;
                }
                default: {
                    builder.put(i, new float[0]);
                }
            }
        }
    }

    public static class Face {
        private Direction face;
        private TextureAtlasSprite sprite;
        private int light;
        private UvRotation uvRotation = UvRotation.CLOCKWISE_0;

        public Face(Direction face, TextureAtlasSprite sprite) {
            this.face = face;
            this.sprite = sprite;
        }

        public Face(Direction face, TextureAtlasSprite sprite, UvRotation uvRotation) {
            this(face, sprite);
            this.uvRotation = uvRotation;
        }

        public Face(Direction face, TextureAtlasSprite sprite, UvRotation uvRotation, int light) {
            this(face, sprite, uvRotation);
            this.light = light;
        }
    }

    private static class Uv {
        private float xFrom;
        private float xTo;
        private float yFrom;
        private float yTo;

        private Uv() {
        }
    }

    public static enum UvRotation {
        CLOCKWISE_0,
        CLOCKWISE_90,
        CLOCKWISE_180,
        CLOCKWISE_270;

    }
}

