/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetFluidFilterSlotMessage {
    private final int containerSlot;
    private final FluidStack stack;

    public SetFluidFilterSlotMessage(int containerSlot, FluidStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public static SetFluidFilterSlotMessage decode(PacketBuffer buf) {
        return new SetFluidFilterSlotMessage(buf.readInt(), FluidStack.readFromPacket((PacketBuffer)buf));
    }

    public static void encode(SetFluidFilterSlotMessage message, PacketBuffer buf) {
        buf.writeInt(message.containerSlot);
        message.stack.writeToPacket(buf);
    }

    public static void handle(SetFluidFilterSlotMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player;
        if (!message.stack.isEmpty() && (player = ctx.get().getSender()) != null) {
            ctx.get().enqueueWork(() -> SetFluidFilterSlotMessage.lambda$handle$0((PlayerEntity)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static void handle(SetFluidFilterSlotMessage message, Container container) {
        Slot slot = container.func_75139_a(message.containerSlot);
        if (slot instanceof FluidFilterSlot) {
            IGrid grid;
            Runnable postAction = () -> {};
            if (container instanceof GridContainer && (grid = ((GridContainer)container).getGrid()) instanceof GridNetworkNode && slot.getSlotIndex() < ((GridNetworkNode)grid).getAllowedTagList().getAllowedFluidTags().size()) {
                HashSet list = new HashSet(((GridNetworkNode)grid).getAllowedTagList().getAllowedFluidTags().get(slot.getSlotIndex()));
                postAction = () -> {
                    ((GridNetworkNode)grid).getAllowedTagList().setAllowedFluidTags(slot.getSlotIndex(), list);
                    ((GridNetworkNode)grid).markDirty();
                };
            }
            FluidFilterSlot fluidSlot = (FluidFilterSlot)slot;
            fluidSlot.getFluidInventory().setFluid(slot.getSlotIndex(), message.stack);
            postAction.run();
        }
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player, SetFluidFilterSlotMessage message) {
        Container container = player.field_71070_bA;
        if (container != null && message.containerSlot >= 0 && message.containerSlot < container.field_75151_b.size()) {
            SetFluidFilterSlotMessage.handle(message, container);
        }
    }
}

