/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternFactory;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.render.tesr.PatternItemStackTileRenderer;
import com.refinedmods.refinedstorage.util.ItemStackKey;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class PatternItem
extends Item
implements ICraftingPatternProvider {
    private static final Map<ItemStackKey, ICraftingPattern> CACHE = new HashMap<ItemStackKey, ICraftingPattern>();
    private static final String NBT_VERSION = "Version";
    private static final String NBT_INPUT_SLOT = "Input_%d";
    private static final String NBT_OUTPUT_SLOT = "Output_%d";
    private static final String NBT_FLUID_INPUT_SLOT = "FluidInput_%d";
    private static final String NBT_FLUID_OUTPUT_SLOT = "FluidOutput_%d";
    private static final String NBT_EXACT = "Exact";
    private static final String NBT_PROCESSING = "Processing";
    private static final String NBT_ALLOWED_TAGS = "AllowedTags";
    private static final int VERSION = 1;

    public PatternItem() {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP).setISTER(() -> PatternItemStackTileRenderer::new));
    }

    public static ICraftingPattern fromCache(World world, ItemStack stack) {
        ICraftingPattern pattern = CACHE.computeIfAbsent(new ItemStackKey(stack), s -> CraftingPatternFactory.INSTANCE.create(world, null, s.getStack()));
        if (CACHE.size() > 16384) {
            CACHE.clear();
        }
        return pattern;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!stack.func_77942_o()) {
            return;
        }
        ICraftingPattern pattern = PatternItem.fromCache(world, stack);
        if (pattern.isValid()) {
            if (Screen.func_231173_s_() || PatternItem.isProcessing(stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.inputs").func_230530_a_(Styles.YELLOW));
                RenderUtils.addCombinedItemsToTooltip(tooltip, true, pattern.getInputs().stream().map(i -> !i.isEmpty() ? (ItemStack)i.get(0) : ItemStack.field_190927_a).collect(Collectors.toList()));
                RenderUtils.addCombinedFluidsToTooltip(tooltip, true, pattern.getFluidInputs().stream().map(i -> !i.isEmpty() ? (FluidStack)i.get(0) : FluidStack.EMPTY).collect(Collectors.toList()));
                tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.outputs").func_230530_a_(Styles.YELLOW));
            }
            RenderUtils.addCombinedItemsToTooltip(tooltip, true, pattern.getOutputs());
            RenderUtils.addCombinedFluidsToTooltip(tooltip, true, pattern.getFluidOutputs());
            if (pattern instanceof CraftingPattern && ((CraftingPattern)pattern).getAllowedTagList() != null) {
                this.addAllowedTags(tooltip, (CraftingPattern)pattern);
            }
            if (PatternItem.isExact(stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.exact").func_230530_a_(Styles.BLUE));
            }
            if (PatternItem.isProcessing(stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.processing").func_230530_a_(Styles.BLUE));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.invalid").func_230530_a_(Styles.RED));
            tooltip.add((ITextComponent)pattern.getErrorMessage().func_230531_f_().func_230530_a_(Styles.GRAY));
        }
    }

    public void addAllowedTags(List<ITextComponent> tooltip, CraftingPattern pattern) {
        Set<ResourceLocation> allowedTags;
        int i;
        for (i = 0; i < pattern.getAllowedTagList().getAllowedItemTags().size(); ++i) {
            allowedTags = pattern.getAllowedTagList().getAllowedItemTags().get(i);
            for (ResourceLocation tag : allowedTags) {
                tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.allowed_item_tag", new Object[]{tag.toString(), ((ItemStack)pattern.getInputs().get(i).get(0)).func_200301_q()}).func_230530_a_(Styles.AQUA));
            }
        }
        for (i = 0; i < pattern.getAllowedTagList().getAllowedFluidTags().size(); ++i) {
            allowedTags = pattern.getAllowedTagList().getAllowedFluidTags().get(i);
            for (ResourceLocation tag : allowedTags) {
                tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.allowed_fluid_tag", new Object[]{tag.toString(), ((FluidStack)pattern.getFluidInputs().get(i).get(0)).getDisplayName()}).func_230530_a_(Styles.AQUA));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && player.func_213453_ef()) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)new ItemStack((IItemProvider)RSItems.PATTERN.get(), player.func_184586_b(hand).func_190916_E()));
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    @Nonnull
    public ICraftingPattern create(World world, ItemStack stack, ICraftingPatternContainer container) {
        return CraftingPatternFactory.INSTANCE.create(world, container, stack);
    }

    public static void setInputSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_218657_a(String.format(NBT_INPUT_SLOT, slot), (INBT)stack.serializeNBT());
    }

    @Nonnull
    public static ItemStack getInputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_INPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)pattern.func_77978_p().func_74775_l(id));
    }

    public static void setOutputSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_218657_a(String.format(NBT_OUTPUT_SLOT, slot), (INBT)stack.serializeNBT());
    }

    @Nonnull
    public static ItemStack getOutputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_OUTPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)pattern.func_77978_p().func_74775_l(id));
    }

    public static void setFluidInputSlot(ItemStack pattern, int slot, FluidStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_218657_a(String.format(NBT_FLUID_INPUT_SLOT, slot), (INBT)stack.writeToNBT(new CompoundNBT()));
    }

    public static FluidStack getFluidInputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_FLUID_INPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)pattern.func_77978_p().func_74775_l(id));
    }

    public static void setFluidOutputSlot(ItemStack pattern, int slot, FluidStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_218657_a(String.format(NBT_FLUID_OUTPUT_SLOT, slot), (INBT)stack.writeToNBT(new CompoundNBT()));
    }

    public static FluidStack getFluidOutputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_FLUID_OUTPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)pattern.func_77978_p().func_74775_l(id));
    }

    public static boolean isProcessing(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_PROCESSING) && pattern.func_77978_p().func_74767_n(NBT_PROCESSING);
    }

    public static void setProcessing(ItemStack pattern, boolean processing) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_74757_a(NBT_PROCESSING, processing);
    }

    public static boolean isExact(ItemStack pattern) {
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(NBT_EXACT)) {
            return false;
        }
        return pattern.func_77978_p().func_74767_n(NBT_EXACT);
    }

    public static void setExact(ItemStack pattern, boolean exact) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_74757_a(NBT_EXACT, exact);
    }

    public static void setToCurrentVersion(ItemStack pattern) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_74768_a(NBT_VERSION, 1);
    }

    public static void setAllowedTags(ItemStack pattern, AllowedTagList allowedTagList) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new CompoundNBT());
        }
        pattern.func_77978_p().func_218657_a(NBT_ALLOWED_TAGS, (INBT)allowedTagList.writeToNbt());
    }

    @Nullable
    public static AllowedTagList getAllowedTags(ItemStack pattern) {
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(NBT_ALLOWED_TAGS)) {
            return null;
        }
        AllowedTagList allowedTagList = new AllowedTagList(null, 81);
        allowedTagList.readFromNbt(pattern.func_77978_p().func_74775_l(NBT_ALLOWED_TAGS));
        return allowedTagList;
    }
}

