/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.inventory.player;

import com.refinedmods.refinedstorage.integration.curios.CuriosIntegration;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;

public class PlayerSlot {
    int slot;
    String curioSlot;

    public PlayerSlot(int slot, String curioSlot) {
        this.slot = slot;
        this.curioSlot = curioSlot;
    }

    public PlayerSlot(int slot) {
        this.slot = slot;
    }

    public PlayerSlot(PacketBuffer buffer) {
        this.slot = buffer.readInt();
        if (buffer.readBoolean()) {
            this.curioSlot = PacketBufferUtils.readString(buffer);
        }
    }

    public ItemStack getStackFromSlot(PlayerEntity player) {
        if (this.curioSlot == null || !CuriosIntegration.isLoaded()) {
            return player.field_71071_by.func_70301_a(this.slot);
        }
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        Optional<ItemStack> stacksHandler = curiosHandler.resolve().flatMap(handler -> handler.getStacksHandler(this.curioSlot));
        Optional<ItemStack> stack = stacksHandler.map(handler -> handler.getStacks().getStackInSlot(this.slot));
        return stack.orElse(ItemStack.field_190927_a);
    }

    public void writePlayerSlot(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
        buffer.writeBoolean(this.curioSlot != null);
        if (this.curioSlot != null) {
            buffer.func_180714_a(this.curioSlot);
        }
    }

    public int getSlotIdInPlayerInventory() {
        if (this.curioSlot != null) {
            return -1;
        }
        return this.slot;
    }

    public static PlayerSlot getSlotForHand(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return new PlayerSlot(player.field_71071_by.field_70461_c);
        }
        return new PlayerSlot(40);
    }
}

