/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.command.network;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import java.text.DecimalFormat;
import java.util.Comparator;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class ListNetworkCommand
implements Command<CommandSource> {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes((Command)new ListNetworkCommand()));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerWorld world = DimensionArgument.func_212592_a(context, (String)"dimension");
        API.instance().getNetworkManager(world).all().stream().map(NetworkInList::new).sorted(Comparator.comparingDouble(network -> ((NetworkInList)network).tickTime)).forEach(listItem -> ListNetworkCommand.sendInfo(context, listItem, false));
        return 0;
    }

    public static void sendInfo(CommandContext<CommandSource> context, NetworkInList listItem, boolean detailed) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.refinedstorage.network.list.pos", new Object[]{listItem.network.getPosition().func_177958_n(), listItem.network.getPosition().func_177956_o(), listItem.network.getPosition().func_177952_p()}).func_240702_b_(" [").func_230529_a_((ITextComponent)new TranslationTextComponent("commands.refinedstorage.network.list.tick_times", new Object[]{new StringTextComponent(TIME_FORMATTER.format(listItem.tickTime)).func_230530_a_(Styles.YELLOW), new StringTextComponent(TIME_FORMATTER.format(listItem.tps)).func_230530_a_(Styles.YELLOW)})).func_240702_b_("]"), false);
        if (detailed) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.refinedstorage.network.list.autocrafting_tasks", new Object[]{new StringTextComponent(listItem.network.getCraftingManager().getTasks().size() + "").func_230530_a_(Styles.YELLOW)}), false);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.refinedstorage.network.list.nodes", new Object[]{new StringTextComponent(listItem.network.getNodeGraph().all().size() + "").func_230530_a_(Styles.YELLOW)}), false);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.refinedstorage.network.list.energy_usage", new Object[]{new StringTextComponent(listItem.network.getEnergyUsage() + "").func_230530_a_(Styles.YELLOW)}), false);
        }
    }

    public static class NetworkInList {
        private final double tickTime;
        private final double tps;
        private final INetwork network;

        public NetworkInList(INetwork network) {
            this.network = network;
            this.tickTime = (double)this.mean(network.getTickTimes()) * 1.0E-6;
            this.tps = Math.min(1000.0 / this.tickTime, 20.0);
        }

        private long mean(long[] values) {
            long sum = 0L;
            for (long v : values) {
                sum += v;
            }
            return sum / (long)values.length;
        }
    }
}

