/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackList
implements IStackList<FluidStack> {
    private final ArrayListMultimap<Fluid, StackListEntry<FluidStack>> stacks = ArrayListMultimap.create();
    private final Map<UUID, FluidStack> index = new HashMap<UUID, FluidStack>();

    public FluidStackList() {
    }

    public FluidStackList(Iterable<FluidStack> stacks) {
        for (FluidStack stack : stacks) {
            this.add(stack);
        }
    }

    @Override
    public StackListResult<FluidStack> add(@Nonnull FluidStack stack, int size) {
        if (stack.isEmpty() || size <= 0) {
            throw new IllegalArgumentException("Cannot accept empty stack");
        }
        for (StackListEntry entry : this.stacks.get((Object)stack.getFluid())) {
            FluidStack otherStack = (FluidStack)entry.getStack();
            if (!stack.isFluidEqual(otherStack)) continue;
            if ((long)otherStack.getAmount() + (long)size > Integer.MAX_VALUE) {
                otherStack.setAmount(Integer.MAX_VALUE);
            } else {
                otherStack.grow(size);
            }
            return new StackListResult<FluidStack>(otherStack, entry.getId(), size);
        }
        FluidStack newStack = stack.copy();
        newStack.setAmount(size);
        StackListEntry<FluidStack> newEntry = new StackListEntry<FluidStack>(newStack);
        this.stacks.put((Object)newStack.getFluid(), newEntry);
        this.index.put(newEntry.getId(), newEntry.getStack());
        return new StackListResult<FluidStack>(newStack, newEntry.getId(), size);
    }

    @Override
    public StackListResult<FluidStack> add(@Nonnull FluidStack stack) {
        return this.add(stack, stack.getAmount());
    }

    @Override
    public StackListResult<FluidStack> remove(@Nonnull FluidStack stack, int size) {
        for (StackListEntry entry : this.stacks.get((Object)stack.getFluid())) {
            FluidStack otherStack = (FluidStack)entry.getStack();
            if (!stack.isFluidEqual(otherStack)) continue;
            if (otherStack.getAmount() - size <= 0) {
                this.stacks.remove((Object)otherStack.getFluid(), (Object)entry);
                this.index.remove(entry.getId());
                return new StackListResult<FluidStack>(otherStack, entry.getId(), -otherStack.getAmount());
            }
            otherStack.shrink(size);
            return new StackListResult<FluidStack>(otherStack, entry.getId(), -size);
        }
        return null;
    }

    @Override
    public StackListResult<FluidStack> remove(@Nonnull FluidStack stack) {
        return this.remove(stack, stack.getAmount());
    }

    @Override
    public int getCount(@Nonnull FluidStack stack, int flags) {
        FluidStack found = this.get(stack, flags);
        if (found == null) {
            return 0;
        }
        return found.getAmount();
    }

    @Override
    @Nullable
    public FluidStack get(@Nonnull FluidStack stack, int flags) {
        for (StackListEntry entry : this.stacks.get((Object)stack.getFluid())) {
            FluidStack otherStack = (FluidStack)entry.getStack();
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public StackListEntry<FluidStack> getEntry(@Nonnull FluidStack stack, int flags) {
        for (StackListEntry entry : this.stacks.get((Object)stack.getFluid())) {
            FluidStack otherStack = (FluidStack)entry.getStack();
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return entry;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack get(UUID id) {
        return this.index.get(id);
    }

    @Override
    public void clear() {
        this.stacks.clear();
        this.index.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<StackListEntry<FluidStack>> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public Collection<StackListEntry<FluidStack>> getStacks(@Nonnull FluidStack stack) {
        return this.stacks.get((Object)stack.getFluid());
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> copy() {
        FluidStackList list = new FluidStackList();
        for (StackListEntry entry : this.stacks.values()) {
            FluidStack newStack = ((FluidStack)entry.getStack()).copy();
            list.stacks.put((Object)((FluidStack)entry.getStack()).getFluid(), new StackListEntry<FluidStack>(entry.getId(), newStack));
            list.index.put(entry.getId(), newStack);
        }
        return list;
    }

    @Override
    public int size() {
        return this.stacks.size();
    }
}

