/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.DiskDriveTile;
import com.refinedmods.refinedstorage.tile.ImporterTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ImporterNetworkNode
extends NetworkNode
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "importer");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FLuidFilters";
    private final BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK).addListener(new NetworkNodeInventoryListener(this));
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int currentSlot;
    private final CoverManager coverManager = new CoverManager(this);

    public ImporterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        FluidStack toDrain;
        FluidStack stack;
        IFluidHandler handler;
        super.update();
        if (!this.canUpdate() || !this.world.func_195588_v(this.pos)) {
            return;
        }
        if (this.type == 0) {
            TileEntity facing = this.getFacingTile();
            IItemHandler handler2 = WorldUtils.getItemHandler(facing, this.getDirection().func_176734_d());
            if (facing instanceof DiskDriveTile || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                while (this.currentSlot + 1 < handler2.getSlots() && handler2.getStackInSlot(this.currentSlot).func_190926_b()) {
                    ++this.currentSlot;
                }
                ItemStack stack2 = handler2.getStackInSlot(this.currentSlot);
                if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, stack2)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    ItemStack result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), true);
                    if (!result.func_190926_b() && this.network.insertItem(result, result.func_190916_E(), Action.SIMULATE).func_190926_b()) {
                        result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), false);
                        this.network.insertItemTracked(result, result.func_190916_E());
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && this.ticks % this.upgrades.getSpeed() == 0 && (handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null && !(stack = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && IWhitelistBlacklist.acceptsFluid(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.getAmount(), Action.SIMULATE).isEmpty() && !(toDrain = handler.drain(1000 * this.upgrades.getStackInteractCount(), IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            FluidStack remainder = this.network.insertFluidTracked(toDrain, toDrain.getAmount());
            if (!remainder.isEmpty()) {
                toDrain.shrink(remainder.getAmount());
            }
            handler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems(this.upgrades, 1, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? ImporterTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

