/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CableNetworkNode
extends NetworkNode
implements ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "cable");
    private final CoverManager coverManager = new CoverManager(this);

    public CableNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public boolean canConduct(Direction direction) {
        return !this.coverManager.hasCover(direction) || this.coverManager.getCover(direction).getType() == CoverType.HOLLOW;
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCable().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    public void read(CompoundNBT tag) {
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        super.read(tag);
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        return super.write(tag);
    }
}

