/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternContext;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternFactoryException;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternInputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternOutputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.InvalidCraftingPattern;
import com.refinedmods.refinedstorage.item.PatternItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPatternFactory {
    public static final CraftingPatternFactory INSTANCE = new CraftingPatternFactory();

    public ICraftingPattern create(World world, ICraftingPatternContainer container, ItemStack stack) {
        ICraftingRecipe recipe;
        NonNullList fluidOutputs;
        ArrayList<NonNullList<FluidStack>> fluidInputs;
        NonNullList byproducts;
        NonNullList outputs;
        ArrayList<NonNullList<ItemStack>> inputs;
        AllowedTagList allowedTagList;
        boolean exact;
        boolean processing;
        CraftingPatternContext context;
        block9: {
            context = new CraftingPatternContext(container, stack);
            processing = PatternItem.isProcessing(stack);
            exact = PatternItem.isExact(stack);
            allowedTagList = PatternItem.getAllowedTags(stack);
            inputs = new ArrayList<NonNullList<ItemStack>>();
            outputs = NonNullList.func_191196_a();
            byproducts = NonNullList.func_191196_a();
            fluidInputs = new ArrayList<NonNullList<FluidStack>>();
            fluidOutputs = NonNullList.func_191196_a();
            recipe = null;
            try {
                if (processing) {
                    for (int i = 0; i < 81; ++i) {
                        this.fillProcessingInputs(i, stack, inputs, (NonNullList<ItemStack>)outputs, allowedTagList);
                        this.fillProcessingFluidInputs(i, stack, fluidInputs, (NonNullList<FluidStack>)fluidOutputs, allowedTagList);
                    }
                    if (outputs.isEmpty() && fluidOutputs.isEmpty()) {
                        throw new CraftingPatternFactoryException((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.error.processing_no_outputs"));
                    }
                    break block9;
                }
                CraftingPattern.DummyCraftingInventory inv = new CraftingPattern.DummyCraftingInventory();
                for (int i = 0; i < 9; ++i) {
                    this.fillCraftingInputs(inv, stack, inputs, i);
                }
                Optional foundRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world);
                if (foundRecipe.isPresent()) {
                    recipe = (ICraftingRecipe)foundRecipe.get();
                    byproducts = recipe.func_179532_b((IInventory)inv);
                    ItemStack output = recipe.func_77572_b((IInventory)inv);
                    if (!output.func_190926_b()) {
                        outputs.add((Object)output);
                        if (!exact) {
                            this.modifyCraftingInputsToUseAlternatives(recipe, inputs);
                        }
                        break block9;
                    }
                    throw new CraftingPatternFactoryException((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.error.no_output"));
                }
                throw new CraftingPatternFactoryException((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.error.recipe_does_not_exist"));
            }
            catch (CraftingPatternFactoryException e) {
                return new InvalidCraftingPattern(context, e.getErrorMessage());
            }
        }
        return new CraftingPattern(context, processing, exact, recipe, new CraftingPatternInputs(inputs, fluidInputs), new CraftingPatternOutputs((NonNullList<ItemStack>)outputs, (NonNullList<ItemStack>)byproducts, (NonNullList<FluidStack>)fluidOutputs), allowedTagList);
    }

    private void fillProcessingInputs(int i, ItemStack stack, List<NonNullList<ItemStack>> inputs, NonNullList<ItemStack> outputs, @Nullable AllowedTagList allowedTagList) throws CraftingPatternFactoryException {
        ItemStack input = PatternItem.getInputSlot(stack, i);
        if (input.func_190926_b()) {
            inputs.add((NonNullList<ItemStack>)NonNullList.func_191196_a());
        } else {
            NonNullList possibilities = NonNullList.func_191196_a();
            possibilities.add((Object)input.func_77946_l());
            if (allowedTagList != null) {
                Collection tagsOfItem = ItemTags.func_199903_a().func_199913_a((Object)input.func_77973_b());
                Set<ResourceLocation> declaredAllowedTags = allowedTagList.getAllowedItemTags().get(i);
                for (ResourceLocation declaredAllowedTag : declaredAllowedTags) {
                    if (!tagsOfItem.contains(declaredAllowedTag)) {
                        throw new CraftingPatternFactoryException((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.error.tag_no_longer_applicable", new Object[]{declaredAllowedTag.toString(), input.func_200301_q()}));
                    }
                    for (Item element : ItemTags.func_199903_a().func_199910_a(declaredAllowedTag).func_230236_b_()) {
                        possibilities.add((Object)new ItemStack((IItemProvider)element, input.func_190916_E()));
                    }
                }
            }
            inputs.add((NonNullList<ItemStack>)possibilities);
        }
        ItemStack output = PatternItem.getOutputSlot(stack, i);
        if (!output.func_190926_b()) {
            outputs.add((Object)output);
        }
    }

    private void fillProcessingFluidInputs(int i, ItemStack stack, List<NonNullList<FluidStack>> fluidInputs, NonNullList<FluidStack> fluidOutputs, @Nullable AllowedTagList allowedTagList) throws CraftingPatternFactoryException {
        FluidStack input = PatternItem.getFluidInputSlot(stack, i);
        if (input.isEmpty()) {
            fluidInputs.add((NonNullList<FluidStack>)NonNullList.func_191196_a());
        } else {
            NonNullList possibilities = NonNullList.func_191196_a();
            possibilities.add((Object)input.copy());
            if (allowedTagList != null) {
                Collection tagsOfFluid = FluidTags.func_226157_a_().func_199913_a((Object)input.getFluid());
                Set<ResourceLocation> declaredAllowedTags = allowedTagList.getAllowedFluidTags().get(i);
                for (ResourceLocation declaredAllowedTag : declaredAllowedTags) {
                    if (!tagsOfFluid.contains(declaredAllowedTag)) {
                        throw new CraftingPatternFactoryException((ITextComponent)new TranslationTextComponent("misc.refinedstorage.pattern.error.tag_no_longer_applicable", new Object[]{declaredAllowedTag.toString(), input.getDisplayName()}));
                    }
                    for (Fluid element : FluidTags.func_226157_a_().func_199910_a(declaredAllowedTag).func_230236_b_()) {
                        possibilities.add((Object)new FluidStack(element, input.getAmount()));
                    }
                }
            }
            fluidInputs.add((NonNullList<FluidStack>)possibilities);
        }
        FluidStack output = PatternItem.getFluidOutputSlot(stack, i);
        if (!output.isEmpty()) {
            fluidOutputs.add((Object)output);
        }
    }

    private void fillCraftingInputs(CraftingInventory inv, ItemStack stack, List<NonNullList<ItemStack>> inputs, int i) {
        ItemStack input = PatternItem.getInputSlot(stack, i);
        inputs.add((NonNullList<ItemStack>)(input.func_190926_b() ? NonNullList.func_191196_a() : NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{input})));
        inv.func_70299_a(i, input);
    }

    private void modifyCraftingInputsToUseAlternatives(ICraftingRecipe recipe, List<NonNullList<ItemStack>> inputs) {
        if (!recipe.func_192400_c().isEmpty()) {
            inputs.clear();
            for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
                inputs.add(i, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])((Ingredient)recipe.func_192400_c().get(i)).func_193365_a()));
            }
        }
    }
}

