/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BioReactorRecipeCategory
implements IRecipeCategory<ReactorRecipeWrapper> {
    public static ResourceLocation ID = new ResourceLocation("industrialforegoing", "bioreactor");
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;
    private String title;

    public BioReactorRecipeCategory(IGuiHelper guiHelper, String title) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
        this.title = title;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends ReactorRecipeWrapper> getRecipeClass() {
        return ReactorRecipeWrapper.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 82, 50);
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(ReactorRecipeWrapper reactorRecipeWrapper, IIngredients iIngredients) {
        iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(reactorRecipeWrapper.getStack().func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList())));
        iIngredients.setOutput(VanillaTypes.FLUID, (Object)reactorRecipeWrapper.getFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ReactorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, true, 0, 16);
        IGuiFluidStackGroup guiFluidStackGroup = recipeLayout.getFluidStacks();
        guiFluidStackGroup.init(1, false, 57, 1, 12, 48, 200, false, this.tankOverlay);
        guiItemStackGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiFluidStackGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public static class ReactorRecipeWrapper {
        private ITag<Item> stack;
        private FluidStack fluid;

        public ReactorRecipeWrapper(ITag<Item> stack, FluidStack fluid) {
            this.stack = stack;
            this.fluid = fluid;
        }

        public ITag<Item> getStack() {
            return this.stack;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }
    }
}

