/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.SubHitVoxelShape;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.ITickablePart;
import codechicken.multipart.api.part.TFacePart;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.TNormalOcclusionPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.util.PartRayTraceResult;
import codechicken.translocators.client.render.RenderTranslocator;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public abstract class TranslocatorPart
extends TMultiPart
implements TFacePart,
TNormalOcclusionPart,
ITickablePart {
    public static final SoundType PLACEMENT_SOUND = new SoundType(1.0f, 1.0f, null, null, SoundEvents.field_187902_gb, null, null);
    public static Cuboid6 base = new Cuboid6(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
    public static Cuboid6[] boxes = new Cuboid6[6];
    public static Cuboid6[][] base_parts = new Cuboid6[6][4];
    public static VoxelShape baseShape = base.shape();
    public static VoxelShape[] boxShapes = new VoxelShape[6];
    public static VoxelShape[][] basePartShapes = new VoxelShape[6][4];
    public static VoxelShape[] basePartsJoined = new VoxelShape[6];
    public static int HIT_BASE = 0;
    public static int HIT_INSERT = 1;
    public byte side;
    public boolean a_eject = true;
    public boolean b_eject = true;
    public boolean redstone;
    public boolean invert_redstone = true;
    public boolean fast;
    public double a_insertpos = 1.0;
    public double b_insertpos = 1.0;

    public void save(CompoundNBT tag) {
        tag.func_74774_a("side", this.side);
        tag.func_74757_a("invert_redstone", this.invert_redstone);
        tag.func_74757_a("redstone", this.redstone);
        tag.func_74757_a("fast", this.fast);
    }

    public void load(CompoundNBT tag) {
        this.side = tag.func_74771_c("side");
        this.invert_redstone = tag.func_74767_n("invert_redstone");
        this.redstone = tag.func_74767_n("redstone");
        this.fast = tag.func_74767_n("fast");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.side);
        packet.writeByte(this.writeFlags());
    }

    public void readDesc(MCDataInput packet) {
        this.side = packet.readByte();
        this.readFlags(packet.readByte());
    }

    protected int writeFlags() {
        int flags = 0;
        flags |= this.a_eject ? 1 : 0;
        flags |= (this.redstone ? 1 : 0) << 1;
        return flags |= (this.fast ? 1 : 0) << 2;
    }

    protected void readFlags(int flags) {
        this.a_eject = (flags & 1) != 0;
        this.redstone = (flags & 2) != 0;
        this.fast = (flags & 4) != 0;
    }

    public final void readUpdate(MCDataInput packet) {
        byte flags = packet.readByte();
        this.readFlags(flags);
        if ((flags & 0x80) != 0) {
            this.readIncUpdate(packet);
        } else {
            this.onPartChanged(this);
            this.tile().markRender();
        }
    }

    public void sendFlagsUpdate() {
        this.sendUpdate(packet -> packet.writeByte(this.writeFlags()));
    }

    public void sendIncUpdate(Consumer<MCDataOutput> func) {
        this.sendUpdate(packet -> {
            packet.writeByte(this.writeFlags() | 0x80);
            func.accept((MCDataOutput)packet);
        });
    }

    public void readIncUpdate(MCDataInput packet) {
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().func_201670_d()) {
            this.onNeighborBlockChanged(this.pos());
        }
        super.onPartChanged(part);
    }

    public boolean solid(int side) {
        return false;
    }

    public SoundType getPlacementSound(ItemUseContext context) {
        return PLACEMENT_SOUND;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public int getSlotMask() {
        return 1 << this.side;
    }

    public Cuboid6 getInsertBounds() {
        return new Cuboid6(0.375, 0.0, 0.375, 0.625, this.a_insertpos * 2.0 / 16.0 + 0.0625, 0.625).apply(Rotation.sideRotations[this.side].at(Vector3.CENTER));
    }

    public VoxelShape getShape(ISelectionContext ctx) {
        return boxShapes[this.side];
    }

    public VoxelShape getOcclusionShape() {
        return boxShapes[this.side];
    }

    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        return VoxelShapes.func_197872_a((VoxelShape)boxShapes[this.side], (VoxelShape)this.getInsertBounds().shape());
    }

    public VoxelShape getInteractionShape() {
        Cuboid6 insert = this.getInsertBounds();
        VoxelShape insertShape = insert.shape();
        List parts = Lists.newArrayList((Object[])base_parts[this.side]).stream().map(b -> new IndexedCuboid6((Object)HIT_BASE, b)).collect(Collectors.toList());
        parts.add(new IndexedCuboid6((Object)HIT_INSERT, this.getInsertBounds()));
        return new SubHitVoxelShape(VoxelShapes.func_197872_a((VoxelShape)basePartsJoined[this.side], (VoxelShape)insertShape), parts);
    }

    public void onNeighborBlockChanged(BlockPos from) {
        if (!this.dropIfCantStay()) {
            this.sendFlagsUpdate();
        }
    }

    public void tick() {
        this.b_insertpos = this.a_insertpos;
        this.a_insertpos = MathHelper.approachExp((double)this.a_insertpos, (double)(this.a_eject ? 1.0 : 0.0), (double)0.5, (double)0.1);
        if (!this.world().func_201670_d()) {
            this.b_eject = this.a_eject;
            boolean bl = this.a_eject = (this.redstone && this.world().func_175640_z(this.pos())) != this.invert_redstone;
            if (this.a_eject != this.b_eject) {
                this.markUpdate();
            }
        }
    }

    public ActionResultType activate(PlayerEntity player, PartRayTraceResult hit, ItemStack held, Hand hand) {
        if (this.world().func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (held.func_190926_b() && player.func_213453_ef()) {
            this.stripModifiers();
            this.markUpdate();
        } else if (held.func_190926_b()) {
            if (hit.subHit == HIT_INSERT) {
                this.invert_redstone = !this.invert_redstone;
            } else {
                this.openGui(player);
            }
        } else if (held.func_77973_b() == Items.field_151137_ax && !this.redstone) {
            this.redstone = true;
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            if (this.world().func_175640_z(this.pos()) == this.invert_redstone == this.a_eject) {
                this.invert_redstone = !this.invert_redstone;
            }
            this.markUpdate();
        } else if (held.func_77973_b() == Items.field_151114_aO && !this.fast) {
            this.fast = true;
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            this.markUpdate();
        } else {
            this.openGui(player);
        }
        return ActionResultType.SUCCESS;
    }

    public void openGui(PlayerEntity player) {
    }

    public void stripModifiers() {
        if (this.redstone) {
            this.redstone = false;
            this.dropItem(new ItemStack((IItemProvider)Items.field_151137_ax));
            if (this.invert_redstone != this.a_eject) {
                boolean bl = this.invert_redstone = !this.invert_redstone;
            }
        }
        if (this.fast) {
            this.fast = false;
            this.dropItem(new ItemStack((IItemProvider)Items.field_151114_aO));
        }
    }

    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getItem());
        if (this.redstone) {
            stacks.add(new ItemStack((IItemProvider)Items.field_151137_ax));
        }
        if (this.fast) {
            stacks.add(new ItemStack((IItemProvider)Items.field_151114_aO));
        }
        return stacks;
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        this.getDrops().forEach(this::dropItem);
        this.tile().remPart((TMultiPart)this);
    }

    public ItemStack pickItem(PartRayTraceResult hit) {
        return this.getItem();
    }

    public abstract ItemStack getItem();

    public abstract int getTType();

    public abstract boolean canStay();

    public TranslocatorPart setupPlacement(PlayerEntity player, Direction side) {
        this.side = (byte)(side.ordinal() ^ 1);
        return this;
    }

    public void markUpdate() {
        this.tile().func_70296_d();
        this.tile().notifyPartChange((TMultiPart)this);
        this.sendFlagsUpdate();
    }

    public boolean canEject() {
        if (!this.world().func_201670_d()) {
            boolean b;
            boolean bl = b = (this.redstone && this.world().func_175640_z(this.pos())) != this.invert_redstone;
            if (b != this.a_eject) {
                return b;
            }
        }
        return this.a_eject;
    }

    public boolean canConnect(int side) {
        TMultiPart other = this.tile().getSlottedPart(side);
        return other instanceof TranslocatorPart && this.getTType() == ((TranslocatorPart)other).getTType();
    }

    public boolean canInsert(int side) {
        return this.canConnect(side) && !((TranslocatorPart)this.tile().getSlottedPart(side)).canEject();
    }

    public <T> T getOther(int side) {
        return (T)this.tile().getSlottedPart(side);
    }

    protected void dropItem(ItemStack stack) {
        TileMultiPart.dropItem((ItemStack)stack, (World)this.world(), (Vector3)Vector3.fromTileCenter((TileEntity)this.tile()));
    }

    public int getIconIndex() {
        int i = 0;
        if (this.redstone) {
            i |= this.world().func_175640_z(this.pos()) ? 2 : 1;
        }
        if (this.fast) {
            i |= 4;
        }
        return i;
    }

    public boolean renderStatic(RenderType layer, CCRenderState ccrs) {
        if (layer == RenderType.func_228639_c_()) {
            ccrs.reset();
            RenderTranslocator.renderStatic(ccrs, this);
        }
        return false;
    }

    public void renderDynamic(MatrixStack mStack, IRenderTypeBuffer buffers, int packedLight, int packedOverlay, float partialTicks) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        RenderTranslocator.renderInsert(this, ccrs, mStack, buffers, packedLight, packedOverlay, partialTicks);
        RenderTranslocator.renderLinks(this, ccrs, mStack, buffers);
    }

    public boolean drawHighlight(PartRayTraceResult hit, ActiveRenderInfo info, MatrixStack mStack, IRenderTypeBuffer getter, float partialTicks) {
        if (hit.subHit == HIT_INSERT) {
            RenderUtils.bufferHitbox((Matrix4)new Matrix4(mStack).translate((Vector3i)hit.func_216350_a()), (IRenderTypeBuffer)getter, (ActiveRenderInfo)info, (Cuboid6)this.getInsertBounds());
            return true;
        }
        return false;
    }

    public Cuboid6 getRenderBounds() {
        return boxes[this.side];
    }

    static {
        for (int i = 0; i < 6; ++i) {
            double d1 = 0.1875;
            double x1 = TranslocatorPart.base.min.x;
            double y1 = TranslocatorPart.base.min.y;
            double z1 = TranslocatorPart.base.min.z;
            double x2 = TranslocatorPart.base.max.x;
            double y2 = TranslocatorPart.base.max.y;
            double z2 = TranslocatorPart.base.max.z;
            Transformation rt = Rotation.sideRotations[i].at(Vector3.CENTER);
            TranslocatorPart.boxes[i] = base.copy().apply(rt);
            TranslocatorPart.base_parts[i] = new Cuboid6[]{new Cuboid6(x1, y1, z1, x1 + d1, y2, z2).apply(rt), new Cuboid6(x2 - d1, y1, z1, x2, y2, z2).apply(rt), new Cuboid6(x1 + d1, y1, z1, x2 - d1, y2, z1 + d1).apply(rt), new Cuboid6(x1 + d1, y1, z2 - d1, x2 - d1, y2, z2).apply(rt)};
            TranslocatorPart.boxShapes[i] = boxes[i].shape();
            TranslocatorPart.basePartShapes[i] = (VoxelShape[])Arrays.stream(base_parts[i]).map(Cuboid6::shape).toArray(VoxelShape[]::new);
            TranslocatorPart.basePartsJoined[i] = Arrays.stream(basePartShapes[i]).reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
        }
    }
}

