/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.redstone.IRedstonePart;
import codechicken.multipart.util.PartRayTraceResult;
import codechicken.translocators.client.render.RenderTranslocator;
import codechicken.translocators.container.ContainerItemTranslocator;
import codechicken.translocators.handler.ConfigHandler;
import codechicken.translocators.init.TranslocatorsModContent;
import codechicken.translocators.part.TranslocatorPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemTranslocatorPart
extends TranslocatorPart
implements IRedstonePart {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_CAP = null;
    public boolean regulate;
    public boolean signal;
    public boolean a_powering;
    public ItemStack regulateStack = ItemStack.field_190927_a;
    public ItemStack[] filters = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[9], (Object)ItemStack.field_190927_a);
    public List<MovingItem> movingItems = new LinkedList<MovingItem>();

    public MultiPartType<?> getType() {
        return (MultiPartType)TranslocatorsModContent.itemTranslocatorPartType.get();
    }

    @Override
    public int getTType() {
        return 0;
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)TranslocatorsModContent.itemTranslocatorItem.get(), 1);
    }

    @Override
    public int getIconIndex() {
        int i = super.getIconIndex();
        if (this.regulate) {
            i |= 8;
        }
        if (this.signal) {
            i |= this.a_powering ? 32 : 16;
        }
        return i;
    }

    @Override
    public boolean canStay() {
        return this.capCache().getCapability(ITEM_CAP, Direction.field_82609_l[this.side]).isPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world().func_201670_d()) {
            this.movingItems.removeIf(MovingItem::update);
        } else {
            IItemHandler[] handlers;
            if (this.a_eject) {
                handlers = new IItemHandler[6];
                for (int i = 0; i < 6; ++i) {
                    handlers[i] = this.canInsert(i) || i == this.side ? (IItemHandler)this.capCache().getCapabilityOr(ITEM_CAP, Direction.field_82609_l[i], (Object)EmptyHandler.INSTANCE) : EmptyHandler.INSTANCE;
                }
                IItemHandler myHandler = handlers[this.side];
                int largestSize = 0;
                int largestSlot = 0;
                for (int slot = 0; slot < myHandler.getSlots(); ++slot) {
                    int size;
                    ItemStack stack = myHandler.getStackInSlot(slot);
                    if (stack.func_190926_b() || !InventoryUtils.canExtractStack((IItemHandler)myHandler, (int)slot)) continue;
                    int n = size = this.fast ? stack.func_190916_E() : 1;
                    if (size <= largestSize || (size = Math.min(size, ItemTranslocatorPart.getExtractableAmount(stack, this, myHandler))) <= largestSize || (size = Math.min(size, ItemTranslocatorPart.getInsertableAmount(stack, this, handlers))) <= largestSize) continue;
                    largestSlot = slot;
                    largestSize = size;
                }
                if (largestSize > 0) {
                    ItemStack move = myHandler.extractItem(largestSlot, largestSize, true);
                    move = move.func_77946_l();
                    int initialCount = move.func_190916_E();
                    ArrayList<MovingItem> transfers = new ArrayList<MovingItem>();
                    this.spreadOutput(move, false, handlers, transfers);
                    this.spreadOutput(move, true, handlers, transfers);
                    myHandler.extractItem(largestSlot, initialCount - move.func_190916_E(), false);
                    this.sendTransferPacket(transfers);
                }
            }
            if (this.signal) {
                handlers = new IItemHandler[6];
                for (int i = 0; i < 6; ++i) {
                    handlers[i] = (IItemHandler)this.capCache().getCapabilityOr(ITEM_CAP, Direction.field_82609_l[this.side], (Object)EmptyHandler.INSTANCE);
                }
                if (this.a_eject) {
                    boolean allSatisfied = true;
                    for (int i = 0; i < 6; ++i) {
                        TMultiPart other = this.tile().getSlottedPart(i);
                        if (!(other instanceof ItemTranslocatorPart)) continue;
                        ItemTranslocatorPart otherPart = (ItemTranslocatorPart)other;
                        if (otherPart.a_eject || otherPart.isSatisfied(handlers[i])) continue;
                        allSatisfied = false;
                    }
                    this.setPowering(allSatisfied);
                } else {
                    this.setPowering(!this.canTransferFilter(handlers[this.side], handlers));
                }
            }
        }
    }

    private void sendTransferPacket(List<MovingItem> transfers) {
        this.sendIncUpdate(packet -> {
            packet.writeVarInt(transfers.size());
            for (MovingItem transfer : transfers) {
                packet.writeByte(transfer.dst);
                packet.writeItemStack(transfer.stack);
            }
        });
    }

    private boolean canTransferFilter(IItemHandler access, IItemHandler[] attached) {
        boolean filterSet = false;
        for (ItemStack filter : this.filters) {
            if (filter.func_190926_b()) continue;
            filterSet = true;
            if (this.regulate && InventoryUtils.countMatchingStacks((IItemHandler)access, (ItemStack)filter, (boolean)false) <= ItemTranslocatorPart.filterCount(this, filter) || ItemTranslocatorPart.getInsertableAmount(filter, this, attached) <= 0) continue;
            return true;
        }
        return !filterSet;
    }

    private boolean isSatisfied(IItemHandler handler) {
        boolean filterSet = false;
        for (ItemStack filter : this.filters) {
            if (filter.func_190926_b()) continue;
            filterSet = true;
            if (!(this.regulate ? InventoryUtils.countMatchingStacks((IItemHandler)handler, (ItemStack)filter, (!this.a_eject ? 1 : 0) != 0) < ItemTranslocatorPart.filterCount(this, filter) : InventoryUtils.getInsertableQuantity((IItemHandler)handler, (ItemStack)filter) > 0)) continue;
            return false;
        }
        return filterSet || !this.hasEmptySpace(handler);
    }

    private boolean hasEmptySpace(IItemHandler handler) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            boolean b;
            ItemStack stack = handler.getStackInSlot(slot);
            boolean bl = b = stack.func_190926_b() || stack.func_77985_e() && stack.func_190916_E() < Math.min(stack.func_77976_d(), handler.getSlotLimit(slot));
            if (!InventoryUtils.canInsertStack((IItemHandler)handler, (int)slot, (ItemStack)new ItemStack((IItemProvider)Items.field_151045_i)) || !b) continue;
            return true;
        }
        return false;
    }

    private void spreadOutput(ItemStack move, boolean rspass, IItemHandler[] attached, List<MovingItem> transfers) {
        if (move.func_190916_E() == 0) {
            return;
        }
        int outputCount = 0;
        int[] outputQuantities = new int[6];
        for (byte i = 0; i < 6; ++i) {
            ItemTranslocatorPart part;
            TMultiPart p = this.tile().getSlottedPart((int)i);
            if (!(p instanceof ItemTranslocatorPart) || (part = (ItemTranslocatorPart)p).canEject() || part.redstone != rspass || i == this.side) continue;
            outputQuantities[i] = ItemTranslocatorPart.getInsertableAmount(move, part, attached[i]);
            if (outputQuantities[i] <= 0) continue;
            ++outputCount;
        }
        for (int dst = 0; dst < 6 && move.func_190916_E() > 0; ++dst) {
            int qty = outputQuantities[dst];
            if (qty <= 0) continue;
            qty = Math.min(qty, move.func_190916_E() / outputCount + this.world().field_73012_v.nextInt(move.func_190916_E() % outputCount + 1));
            --outputCount;
            if (qty == 0) continue;
            IItemHandler handler = attached[dst];
            ItemStack add = ItemUtils.copyStack((ItemStack)move, (int)qty);
            ItemStack remain = InventoryUtils.insertItem((IItemHandler)handler, (ItemStack)add, (boolean)false);
            move.func_190918_g(qty - remain.func_190916_E());
            add.func_190918_g(remain.func_190916_E());
            if (add.func_190926_b()) continue;
            transfers.add(new MovingItem(dst, add));
        }
    }

    private static int filterCount(ItemTranslocatorPart part, ItemStack stack) {
        boolean filterSet = false;
        int match = 0;
        for (ItemStack filter : part.filters) {
            if (filter.func_190926_b()) continue;
            filterSet = true;
            if (!ItemUtils.areStacksSameType((ItemStack)stack, (ItemStack)filter)) continue;
            match += filter.func_190916_E();
        }
        return filterSet ? match : -1;
    }

    private static int getInsertableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler[] handler) {
        int insertableAmount = 0;
        for (int i = 0; i < 6; ++i) {
            if (!me.canInsert(i)) continue;
            insertableAmount += ItemTranslocatorPart.getInsertableAmount(stack, (ItemTranslocatorPart)((Object)me.getOther(i)), handler[i]);
        }
        return insertableAmount;
    }

    private static int getInsertableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler range) {
        int filter = ItemTranslocatorPart.filterCount(me, stack);
        if (filter == 0) {
            return 0;
        }
        int fit = InventoryUtils.getInsertableQuantity((IItemHandler)range, (ItemStack)stack);
        if (fit == 0) {
            return 0;
        }
        if (me.regulate && filter > 0) {
            fit = Math.min(fit, filter - InventoryUtils.countMatchingStacks((IItemHandler)range, (ItemStack)stack, (boolean)true));
        }
        return Math.max(fit, 0);
    }

    private static int getExtractableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler handler) {
        int qty;
        int filter = ItemTranslocatorPart.filterCount(me, stack);
        if (filter == 0) {
            return me.regulate ? stack.func_77976_d() : 0;
        }
        int n = qty = filter < 0 ? stack.func_77976_d() : filter;
        if (me.regulate && filter > 0) {
            qty = Math.min(qty, InventoryUtils.countMatchingStacks((IItemHandler)handler, (ItemStack)stack, (boolean)false) - filter);
        }
        return Math.max(qty, 0);
    }

    @Override
    public ActionResultType activate(PlayerEntity player, PartRayTraceResult hit, ItemStack held, Hand hand) {
        if (this.world().func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b().func_206844_a(ConfigHandler.regulateTag) && !this.regulate) {
            this.regulateStack = ItemUtils.copyStack((ItemStack)stack, (int)1);
            this.regulate = true;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.markUpdate();
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() == Items.field_151042_j && !this.signal) {
            this.signal = true;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.markUpdate();
            return ActionResultType.SUCCESS;
        }
        return super.activate(player, hit, stack, hand);
    }

    @Override
    public void stripModifiers() {
        super.stripModifiers();
        if (this.regulate) {
            this.regulate = false;
            this.dropItem(this.regulateStack);
            this.regulateStack = ItemStack.field_190927_a;
        }
        if (this.signal) {
            this.setPowering(false);
            this.signal = false;
            this.dropItem(new ItemStack((IItemProvider)Items.field_151042_j));
        }
    }

    @Override
    public void openGui(PlayerEntity player) {
        this.openItemGui(player, this.filters, this.regulate ? "gui.translocators.regulate" : "gui.translocators.filter");
    }

    private void openItemGui(PlayerEntity player, ItemStack[] filters, String name) {
        SimpleNamedContainerProvider provider = new SimpleNamedContainerProvider((id, inv, p) -> {
            class Inv
            extends InventorySimple {
                public Inv(ItemStack[] items, int limit) {
                    super(items, limit);
                }

                public void func_70296_d() {
                    ItemTranslocatorPart.this.markUpdate();
                }
            }
            return new ContainerItemTranslocator(id, inv, new Inv(filters, this.filterStackLimit()));
        }, (ITextComponent)new TranslationTextComponent(name));
        ServerUtils.openContainer((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, p -> p.writeShort(this.filterStackLimit()));
    }

    private int filterStackLimit() {
        if (this.regulate) {
            return 65535;
        }
        if (this.fast) {
            return 64;
        }
        return 1;
    }

    public void setPowering(boolean b) {
        if ((this.signal || !b) && b != this.a_powering) {
            this.a_powering = b;
            this.world().func_195593_d(this.pos(), Blocks.field_150488_af);
            this.world().func_195593_d(this.pos().func_177972_a(Direction.field_82609_l[this.side]), Blocks.field_150488_af);
            this.markUpdate();
        }
    }

    @Override
    public void readIncUpdate(MCDataInput packet) {
        int expected = packet.readVarInt();
        for (int i = 0; i < expected; ++i) {
            byte dst = packet.readByte();
            ItemStack stack = packet.readItemStack();
            this.movingItems.add(new MovingItem(dst, stack));
        }
    }

    @Override
    public void save(CompoundNBT tag) {
        super.save(tag);
        tag.func_74757_a("regulate", this.regulate);
        tag.func_74757_a("signal", this.signal);
        tag.func_74757_a("powering", this.a_powering);
        tag.func_218657_a("filters", (INBT)InventoryUtils.writeItemStacksToTag((ItemStack[])this.filters, (int)65536));
        tag.func_218657_a("regulateStack", (INBT)this.regulateStack.func_77955_b(new CompoundNBT()));
    }

    @Override
    public void load(CompoundNBT tag) {
        super.load(tag);
        this.regulate = tag.func_74767_n("regulate");
        this.signal = tag.func_74767_n("signal");
        this.a_powering = tag.func_74767_n("powering");
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.filters, (ListNBT)tag.func_150295_c("filters", 10));
        this.regulateStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("regulateStack"));
    }

    @Override
    protected int writeFlags() {
        int flags = super.writeFlags();
        flags |= (this.regulate ? 1 : 0) << 3;
        flags |= (this.signal ? 1 : 0) << 4;
        return flags |= (this.a_powering ? 1 : 0) << 5;
    }

    @Override
    protected void readFlags(int flags) {
        super.readFlags(flags);
        this.regulate = (flags & 8) != 0;
        this.signal = (flags & 0x10) != 0;
        this.a_powering = (flags & 0x20) != 0;
    }

    @Override
    public void renderDynamic(MatrixStack mStack, IRenderTypeBuffer buffers, int packedLight, int packedOverlay, float partialTicks) {
        super.renderDynamic(mStack, buffers, packedLight, packedOverlay, partialTicks);
        RenderTranslocator.renderItem(this, mStack, buffers, packedLight, packedOverlay, partialTicks);
    }

    public int strongPowerLevel(int side) {
        return this.a_powering && side == this.side ? 15 : 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public boolean canConnectRedstone(int side) {
        return this.redstone;
    }

    public static class MovingItem {
        public int dst;
        public ItemStack stack;
        public double a_progress;
        public double b_progress;

        public MovingItem(int dst, ItemStack stack) {
            this.dst = dst;
            this.stack = stack;
        }

        public boolean update() {
            if (this.a_progress >= 1.0) {
                return true;
            }
            this.b_progress = this.a_progress;
            this.a_progress = MathHelper.approachLinear((double)this.a_progress, (double)1.0, (double)0.2);
            return false;
        }
    }
}

