/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.init;

import codechicken.lib.inventory.container.ICCLContainerType;
import codechicken.lib.util.CrashLock;
import codechicken.lib.util.SneakyUtils;
import codechicken.multipart.api.MultiPartType;
import codechicken.multipart.api.SimpleMultiPartType;
import codechicken.translocators.block.BlockCraftingGrid;
import codechicken.translocators.container.ContainerItemTranslocator;
import codechicken.translocators.item.FluidTranslocatorItem;
import codechicken.translocators.item.ItemTranslocatorItem;
import codechicken.translocators.part.FluidTranslocatorPart;
import codechicken.translocators.part.ItemTranslocatorPart;
import codechicken.translocators.tile.TileCraftingGrid;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TranslocatorsModContent {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create(Item.class, (String)"translocators");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create(Block.class, (String)"translocators");
    private static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"translocators");
    private static final DeferredRegister<MultiPartType<?>> PARTS = DeferredRegister.create((Class)((Class)SneakyUtils.unsafeCast(MultiPartType.class)), (String)"translocators");
    private static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = DeferredRegister.create((Class)((Class)SneakyUtils.unsafeCast(ContainerType.class)), (String)"translocators");
    public static Tags.IOptionalNamedTag<Item> diamondNuggetTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge:nuggets/diamond"));
    public static Tags.IOptionalNamedTag<Item> regulateItemsTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation("translocators:regulate"));
    public static RegistryObject<ItemTranslocatorItem> itemTranslocatorItem = ITEMS.register("item_translocator", () -> new ItemTranslocatorItem(new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
    public static RegistryObject<FluidTranslocatorItem> fluidTranslocatorItem = ITEMS.register("fluid_translocator", () -> new FluidTranslocatorItem(new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
    public static RegistryObject<Item> diamondNuggetItem = ITEMS.register("diamond_nugget", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
    public static RegistryObject<BlockCraftingGrid> blockCraftingGrid = BLOCKS.register("crafting_grid", BlockCraftingGrid::new);
    public static RegistryObject<TileEntityType<TileCraftingGrid>> tileCraftingGridType = TILES.register("crafting_grid", () -> TileEntityType.Builder.func_223042_a(TileCraftingGrid::new, (Block[])new Block[]{(Block)blockCraftingGrid.get()}).func_206865_a(null));
    public static RegistryObject<MultiPartType<ItemTranslocatorPart>> itemTranslocatorPartType = PARTS.register("item_translocator", () -> new SimpleMultiPartType(s -> new ItemTranslocatorPart()));
    public static RegistryObject<MultiPartType<FluidTranslocatorPart>> fluidTranslocatorPartType = PARTS.register("fluid_translocator", () -> new SimpleMultiPartType(s -> new FluidTranslocatorPart()));
    public static RegistryObject<ContainerType<ContainerItemTranslocator>> containerItemTranslocator = CONTAINER_TYPES.register("item_translocator", () -> ICCLContainerType.create(ContainerItemTranslocator::new));

    public static void init() {
        LOCK.lock();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TILES.register(bus);
        PARTS.register(bus);
        CONTAINER_TYPES.register(bus);
    }
}

