/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class CraftingHelpers {
    private static RecipeManager CLIENT_RECIPE_MANAGER;
    private static final LoadingCache<Triple<IRecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<IRecipe>> CACHE_RECIPES;

    public static void load() {
        MinecraftForge.EVENT_BUS.register(CraftingHelpers.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRecipesLoaded(RecipesUpdatedEvent event) {
        CLIENT_RECIPE_MANAGER = event.getRecipeManager();
    }

    public static <C extends IInventory, T extends IRecipe<C>> Collection<T> findRecipes(World world, IRecipeType<? extends T> recipeType) {
        return world.func_201670_d() ? CraftingHelpers.getClientRecipes(recipeType) : CraftingHelpers.findServerRecipes((ServerWorld)world, recipeType);
    }

    public static RecipeManager getRecipeManager() {
        return MinecraftHelpers.isClientSide() ? (CLIENT_RECIPE_MANAGER != null ? CLIENT_RECIPE_MANAGER : Minecraft.func_71410_x().func_147114_u().func_199526_e()) : Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_), "Server is still loading").func_199532_z();
    }

    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> getServerRecipe(IRecipeType<? extends T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(CraftingHelpers.getRecipeManager().func_215366_a(recipeType).get(recipeName));
    }

    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> findServerRecipe(IRecipeType<T> recipeType, C container, World world) {
        return world.func_199532_z().func_215371_a(recipeType, container, world);
    }

    public static <C extends IInventory, T extends IRecipe<C>> Collection<T> findServerRecipes(IRecipeType<? extends T> recipeType) {
        return CraftingHelpers.findServerRecipes(Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_)), recipeType);
    }

    public static <C extends IInventory, T extends IRecipe<C>> Collection<T> findServerRecipes(ServerWorld world, IRecipeType<? extends T> recipeType) {
        return world.func_199532_z().func_215366_a(recipeType).values();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> getClientRecipe(IRecipeType<? extends T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(CraftingHelpers.getRecipeManager().func_215366_a(recipeType).get(recipeName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> Collection<T> getClientRecipes(IRecipeType<? extends T> recipeType) {
        return CraftingHelpers.getRecipeManager().func_215366_a(recipeType).values();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> T findClientRecipe(ItemStack itemStack, IRecipeType<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (IRecipe recipe : CraftingHelpers.getClientRecipes(recipeType)) {
            if (!ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)itemStack) || indexAttempt-- != 0) continue;
            return (T)recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + itemStack + "::" + itemStack.func_77978_p() + " with index " + index);
    }

    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> findRecipeCached(IRecipeType<T> recipeType, C inventoryCrafting, World world, boolean uniqueInventory) {
        return (Optional)CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.func_234923_W_().func_240901_a_()));
    }

    static {
        CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<IRecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<IRecipe>>(){

            public Optional<IRecipe> load(Triple<IRecipeType<?>, CacheableCraftingInventory, ResourceLocation> key) throws Exception {
                ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)key.getRight())));
                return world.func_199532_z().func_215371_a((IRecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (World)world);
            }
        });
    }

    public static class CacheableCraftingInventory {
        private final IInventory inventoryCrafting;

        public CacheableCraftingInventory(IInventory inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                this.inventoryCrafting = new CraftingInventory(new Container(null, 0){

                    public boolean func_75145_c(PlayerEntity playerIn) {
                        return false;
                    }
                }, inventoryCrafting.func_70302_i_(), 1);
                for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
                    this.inventoryCrafting.func_70299_a(i, inventoryCrafting.func_70301_a(i).func_77946_l());
                }
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public IInventory getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().func_70302_i_(); ++i) {
                if (ItemStack.func_77989_b((ItemStack)this.getInventoryCrafting().func_70301_a(i), (ItemStack)((CacheableCraftingInventory)obj).getInventoryCrafting().func_70301_a(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().func_70302_i_();
            for (int i = 0; i < this.getInventoryCrafting().func_70302_i_(); ++i) {
                hash <<= 1;
                hash |= ItemStackHelpers.getItemStackHashCode(this.getInventoryCrafting().func_70301_a(i));
            }
            return hash;
        }
    }
}

