/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public abstract class RenderTileEntityModel<T extends CyclopsTileEntity, M>
extends TileEntityRenderer<T> {
    protected final M model;
    private final RenderMaterial material;

    public RenderTileEntityModel(TileEntityRendererDispatcher renderDispatcher, M model, RenderMaterial material) {
        super(renderDispatcher);
        this.model = model;
        this.material = material;
    }

    public RenderMaterial getMaterial() {
        return this.material;
    }

    public Function<ResourceLocation, RenderType> getRenderTypeGetter() {
        return RenderType::func_228638_b_;
    }

    protected void preRotate(T tile) {
        GlStateManager.func_227688_c_((float)0.5f, (float)0.5f, (float)0.5f);
    }

    protected void postRotate(T tile) {
        GlStateManager.func_227688_c_((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    public void render(T tile, float partialTick, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Direction direction = ((CyclopsTileEntity)tile).getRotation();
        IVertexBuilder vertexBuilder = this.material.func_229311_a_(buffer, this.getRenderTypeGetter());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.0, 1.0);
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        this.preRotate(tile);
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = 180;
        }
        if (direction == Direction.NORTH) {
            rotation = 0;
        }
        if (direction == Direction.EAST) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = -90;
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation));
        this.postRotate(tile);
        this.renderModel(tile, this.getModel(), partialTick, matrixStack, vertexBuilder, buffer, combinedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }

    protected abstract void renderModel(T var1, M var2, float var3, MatrixStack var4, IVertexBuilder var5, IRenderTypeBuffer var6, int var7, int var8);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderTileEntityModel)) {
            return false;
        }
        RenderTileEntityModel other = (RenderTileEntityModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        M this$model = this.getModel();
        M other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        RenderMaterial this$material = this.getMaterial();
        RenderMaterial other$material = other.getMaterial();
        return !(this$material == null ? other$material != null : !this$material.equals(other$material));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderTileEntityModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        M $model = this.getModel();
        result = result * 59 + ($model == null ? 0 : $model.hashCode());
        RenderMaterial $material = this.getMaterial();
        result = result * 59 + ($material == null ? 0 : $material.hashCode());
        return result;
    }

    public M getModel() {
        return this.model;
    }

    public String toString() {
        return "RenderTileEntityModel(model=" + this.getModel() + ", material=" + this.getMaterial() + ")";
    }
}

