/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import java.util.Random;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.core.client.Localization;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperPigmentHandler;

public class TypePigment {
    public static void init() {
        if (((Boolean)Configuration.INTEGRATION.storeMekanismPigment.get()).booleanValue() && IPigmentHandler.class != null) {
            HandlerRegistry.register(Capabilities.PIGMENT_HANDLER_CAPABILITY, PigmentTankHandler.Provider.INSTANCE);
        }
    }

    public static class PigmentTankHandler
    implements ITankHandler<IPigmentHandler> {
        private final ChemicalTankBuilder.BasicPigmentTank pigmentTank;
        private final IPigmentHandler pigmentTankInsertOnly;
        private final IPigmentHandler pigmentTankExtractOnly;
        private long tankCapacity;

        public PigmentTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = tank.getCapacity() * 1000;
            this.pigmentTank = new ChemicalTankBuilder.BasicPigmentTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.pigmentTankInsertOnly = new WrapperPigmentHandler((IPigmentHandler)this.pigmentTank, true, false);
            this.pigmentTankExtractOnly = new WrapperPigmentHandler((IPigmentHandler)this.pigmentTank, false, true);
        }

        @Override
        public IPigmentHandler getTank(StorageAccessMode access) {
            switch (access) {
                case INSERT_ONLY: {
                    return this.pigmentTankInsertOnly;
                }
                case EXTRACT_ONLY: {
                    return this.pigmentTankExtractOnly;
                }
            }
            return this.pigmentTank;
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.pigmentTank.onContentsChanged();
            }
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.pigmentTank.deserializeNBT(nbt);
        }

        @Override
        public CompoundNBT save() {
            return !this.pigmentTank.isEmpty() ? this.pigmentTank.serializeNBT() : null;
        }

        @Override
        public String getContentsInfo() {
            PigmentStack stack = (PigmentStack)this.pigmentTank.getStack();
            if (!stack.isEmpty()) {
                return String.format(" %s %s [%sK/%sK mB]", Localization.get((String)"info.endertanks.tank.type.mekanism.pigment.txt"), Localization.get((String)((Pigment)stack.getType()).getTranslationKey()), Float.valueOf((float)stack.getAmount() / 1000.0f), this.pigmentTank.getCapacity() / 1000L);
            }
            return "";
        }

        @Override
        public void preformPumpAction(World world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, int pumpCapacity, Random random) {
            PigmentStack pigmentStack;
            long used;
            IPigmentHandler fromHandler = this.getHandler(world.func_175625_s(pullFromPos), facing);
            IPigmentHandler toHandler = this.getHandler(world.func_175625_s(pushToPos), facing.func_176734_d());
            if (fromHandler != null && (used = (pigmentStack = (PigmentStack)fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((PigmentStack)this.pigmentTank.insertChemical((ChemicalStack)pigmentStack, Action.SIMULATE)).getAmount()) > 0L) {
                this.pigmentTank.insertChemical(fromHandler.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
            if (toHandler != null && (used = (pigmentStack = (PigmentStack)this.pigmentTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - ((PigmentStack)toHandler.insertChemical((ChemicalStack)pigmentStack, Action.SIMULATE)).getAmount()) > 0L) {
                toHandler.insertChemical(this.pigmentTank.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
        }

        public IPigmentHandler getHandler(TileEntity tile, Direction facing) {
            return tile == null ? null : (IPigmentHandler)tile.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY, facing).orElse(null);
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<IPigmentHandler> {
            public static Provider INSTANCE = new Provider();

            @Override
            public ITankHandler<IPigmentHandler> create(IEnderTankInfo tank) {
                return new PigmentTankHandler(tank);
            }
        }
    }
}

