/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IRGB16_Tile {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private final ArrayList<ItemStack> pumpUpgrades = new ArrayList();
    public long lastClick = 0L;
    private final List<String> usedUpgrades = new ArrayList<String>();

    public TileEntityEnderTank() {
        super(Values.tileEnderTank);
    }

    public void buildNBT(CompoundNBT nbtTag) {
        nbtTag.func_74778_a("code", this.getCode());
        nbtTag.func_74778_a("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.func_74778_a("owner.id", this.ownerID);
        }
        nbtTag.func_74778_a("owner_id", this.getOwnerID());
        if (!this.pumpUpgrades.isEmpty()) {
            ListNBT listItems = new ListNBT();
            for (ItemStack stack : this.pumpUpgrades) {
                CompoundNBT compound = new CompoundNBT();
                stack.func_77955_b(compound);
                listItems.add((Object)compound);
            }
            nbtTag.func_218657_a("upgrade.pump", (INBT)listItems);
        }
        if (this.personalItem != null) {
            CompoundNBT compound = new CompoundNBT();
            this.personalItem.func_77955_b(compound);
            nbtTag.func_218657_a("upgrade.access", (INBT)compound);
            nbtTag.func_74778_a("personal", this.personalItem.func_77973_b().getRegistryName().toString());
        }
        if (!this.usedUpgrades.isEmpty()) {
            ListNBT listNBT = new ListNBT();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)upgrade));
            }
            nbtTag.func_218657_a("used_upgrades", (INBT)listNBT);
        }
    }

    public void processNBT(CompoundNBT nbtTag) {
        this.setCode(nbtTag.func_74779_i("code"));
        this.owner = nbtTag.func_74779_i("owner");
        if (nbtTag.func_74764_b("owner.id")) {
            this.ownerID = nbtTag.func_74779_i("owner.id");
        }
        if (nbtTag.func_74764_b("upgrade.pump")) {
            this.pumpUpgrades.clear();
            ListNBT listItems = nbtTag.func_150295_c("upgrade.pump", 10);
            for (int entry2 = 0; entry2 < listItems.size(); ++entry2) {
                CompoundNBT compound = listItems.func_150305_b(entry2);
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compound);
                if (stack.func_190926_b()) continue;
                if (stack.func_190916_E() != 1) {
                    stack.func_190920_e(1);
                }
                this.pumpUpgrades.add(stack);
            }
        }
        if (nbtTag.func_74764_b("upgrade.access")) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("upgrade.access"));
            if (!stack.func_190926_b() && stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            this.personalItem = stack;
        }
        if (nbtTag.func_74764_b("used_upgrades")) {
            this.usedUpgrades.clear();
            ListNBT listNBT = nbtTag.func_150295_c("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.func_150285_a_()));
        }
    }

    public void processNBT_SaveOnly(CompoundNBT nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    public boolean applyItem(ItemStack stack) {
        String key = stack.func_77973_b().getRegistryName().toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> optional;
        StorageAccessMode accessMode;
        if (this.canBeAutomated() && (accessMode = this.getAccessForFace(facing)) != null && (optional = this.getEnderContainer().getCapability(capability, accessMode)).isPresent()) {
            return optional;
        }
        return super.getCapability(capability, facing);
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? (Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPublic.get() : (this.isTeam() ? ((Boolean)Configuration.ACCESS_SETTINGS.enableAutomationTeam.get()).booleanValue() : ((Boolean)Configuration.ACCESS_SETTINGS.enableAutomationPersonal.get()).booleanValue());
    }

    private StorageAccessMode getAccessForFace(Direction facing) {
        if (facing == null) {
            return StorageAccessMode.FULL;
        }
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        Direction tFacing = BlockEnderTank.getFacing(state);
        if (tFacing.func_176740_k() == facing.func_176740_k()) {
            if (BlockEnderTank.isPowered(state)) {
                return facing == tFacing ? StorageAccessMode.EXTRACT_ONLY : StorageAccessMode.INSERT_ONLY;
            }
            return StorageAccessMode.FULL;
        }
        return null;
    }

    public EnderContainer getEnderContainer() {
        return TankHelper.getTank(this.getOwnerID(), this.getCode(), this.func_145831_w().field_72995_K);
    }

    public int getPumpCapacity() {
        return this.pumpUpgrades.isEmpty() ? 250 : this.pumpUpgrades.size() * 1000;
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(ItemStack stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(PlayerEntity player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamEdit.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalEdit.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canEdit;
    }

    public boolean canUse(PlayerEntity player) {
        boolean canUse = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamUse.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.allowPublicTanks.get();
                msg = "public.disabled";
            } else {
                canUse = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalUse.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canUse;
    }

    public boolean canLink(PlayerEntity player) {
        boolean canLink = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamBuckets.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockTeamLink.get() == false || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "tank.team.denied";
                } else {
                    canLink = false;
                    msg = "bucket.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBuckets.get()).booleanValue()) {
                    canLink = (Boolean)Configuration.ACCESS_SETTINGS.lockPersonalLink.get() == false || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                    msg = "tank.private.denied";
                } else {
                    canLink = false;
                    msg = "bucket.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(PlayerEntity player) {
        String team = Function.getPlayerTeamID((PlayerEntity)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    private String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return TankInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(PlayerEntity player, ItemStack stack) {
        this.clearMyLocation();
        this.personalItem = stack;
        this.owner = player.func_145748_c_().getString();
        this.ownerID = player.func_110124_au().toString();
        this.setMyLocation();
    }

    public void setOwner(String ownerName, String ownerID, ItemStack stack) {
        this.clearMyLocation();
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
        this.setMyLocation();
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null) {
            if (this.personalItem.func_190916_E() != 1) {
                this.personalItem.func_190920_e(1);
            }
            return this.personalItem;
        }
        return null;
    }

    public ArrayList<ItemStack> getPumpUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (!this.pumpUpgrades.isEmpty()) {
            for (ItemStack stack : this.pumpUpgrades) {
                if (stack == null) continue;
                if (stack.func_190916_E() != 1) {
                    stack.func_190920_e(1);
                }
                upgrades.add(stack);
            }
        }
        return upgrades;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        this.clearMyLocation();
        while (code.length() < 3) {
            code = "0" + code;
        }
        this.code = code.toUpperCase();
        this.setMyLocation();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(PlayerEntity player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(DyeColor.func_196056_a((int)value).func_176762_d());
    }

    public boolean setRGB16(short rgbIndex, PlayerEntity player) {
        return this.doColorRing(DyeColor.func_196056_a((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(DyeColor color, PlayerEntity player) {
        if (player == null || !this.canEdit(player) || !((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue()) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.func_196059_a()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((TileEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(PlayerEntity player) {
        VoxelShape[] shapes = BlockEnderTank.SHAPES.get(this.func_195044_w().func_177229_b((Property)BlockEnderTank.FACING));
        return Function.getSubShapeHit((Entity)player, (BlockPos)this.func_174877_v(), (VoxelShape[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.setMyLocation();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.clearMyLocation();
    }
}

