/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class LocationManager {
    private static final Table<String, String, List<TileReference>> LOCATIONS = HashBasedTable.create();

    static void clear() {
        LOCATIONS.clear();
    }

    public static void set(String owner, String code, TileEntityEnderTank tile) {
        ArrayList<TileReference> list = (ArrayList<TileReference>)LOCATIONS.get((Object)owner, (Object)code);
        if (list == null) {
            list = new ArrayList<TileReference>();
            LOCATIONS.put((Object)owner, (Object)code, list);
        }
        list.add(new TileReference(tile));
    }

    public static void clear(String owner, String code, TileEntityEnderTank tile) {
        List list = (List)LOCATIONS.get((Object)owner, (Object)code);
        if (list != null) {
            list.remove((Object)tile);
            if (list.isEmpty()) {
                LOCATIONS.remove((Object)owner, (Object)code);
            }
        }
    }

    public static void doBlockUpdate(String owner, String code) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> LocationManager.preformBlockUpdate(owner, code));
        }
    }

    private static void preformBlockUpdate(String owner, String code) {
        List locations = (List)LOCATIONS.get((Object)owner, (Object)code);
        if (locations != null && !locations.isEmpty()) {
            UnmodifiableIterator iterator = ImmutableList.copyOf((Collection)locations).iterator();
            iterator.forEachRemaining(reference -> {
                TileEntityEnderTank tile = (TileEntityEnderTank)((Object)((Object)reference.get()));
                if (tile != null && !tile.func_145837_r() && tile.func_145830_o()) {
                    World world = tile.func_145831_w();
                    if (world.func_175667_e(tile.func_174877_v())) {
                        world.func_195593_d(tile.func_174877_v(), Values.blockEnderTank);
                    }
                } else {
                    locations.remove(reference);
                }
            });
        }
        if (locations == null || locations.isEmpty()) {
            LOCATIONS.remove((Object)owner, (Object)code);
        }
    }

    private static class TileReference
    extends WeakReference<TileEntityEnderTank> {
        TileReference(TileEntityEnderTank referent) {
            super(referent);
        }

        public boolean equals(Object object) {
            TileEntityEnderTank myTile = (TileEntityEnderTank)((Object)this.get());
            if (myTile != null) {
                if (object instanceof TileEntityEnderTank) {
                    return ((Object)((Object)myTile)).equals(object);
                }
                if (object instanceof TileReference) {
                    return ((Object)((Object)myTile)).equals(((TileReference)object).get());
                }
            }
            return false;
        }
    }
}

