/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CauldronHelper {
    private static int LEVELS = 3;
    private static FluidStack WATER = new FluidStack((Fluid)Fluids.field_204546_a, 1000);

    public static boolean isCauldron(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof CauldronBlock;
    }

    public static boolean fillCauldron(IFluidHandler eTank, World world, BlockPos pos, boolean drainTank) {
        FluidStack fluidStack;
        BlockState state;
        Block block;
        if (eTank != null && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof CauldronBlock && state.func_185888_a(world, pos) == 0 && !(fluidStack = eTank.drain(WATER, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && fluidStack.getAmount() == 1000) {
            ((CauldronBlock)block).func_176590_a(world, pos, state, LEVELS);
            if (drainTank) {
                eTank.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    public static boolean drainCauldron(IFluidHandler eTank, World world, BlockPos pos, boolean fillTank) {
        BlockState state;
        Block block;
        if (eTank != null && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof CauldronBlock && state.func_185888_a(world, pos) == LEVELS && eTank.fill(WATER, IFluidHandler.FluidAction.SIMULATE) == 1000) {
            ((CauldronBlock)block).func_176590_a(world, pos, state, 0);
            if (fillTank) {
                eTank.fill(WATER, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        return false;
    }
}

