/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.block;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.Materials;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.common.block.HitBoxHelper;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class BlockEnderTank
extends Block
implements IColored {
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"variant", EnumType.class);
    private static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final HashMap<Direction, VoxelShape[]> SHAPES = new HashMap();

    public BlockEnderTank() {
        super(AbstractBlock.Properties.func_200949_a((Material)Materials.IMMOVABLE_TRANSLUCENT, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(1.5f, 5.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_226896_b_().func_235842_b_((state, world, pos) -> false));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, VARIANT, POWERED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityEnderTank();
    }

    private TileEntityEnderTank getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityEnderTank ? (TileEntityEnderTank)tile : null;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (SHAPES.isEmpty()) {
            Map<Direction, VoxelShape> tank_body = HitBoxHelper.getBody();
            Map<Direction, VoxelShape> top_ring = HitBoxHelper.getRing_Top();
            Map<Direction, VoxelShape> middle_ring = HitBoxHelper.getRing_Middle();
            Map<Direction, VoxelShape> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (Direction direction : Direction.values()) {
                VoxelShape[] shapes = new VoxelShape[]{tank_body.getOrDefault(direction, VoxelShapes.func_197880_a()), top_ring.getOrDefault(direction, VoxelShapes.func_197880_a()), middle_ring.getOrDefault(direction, VoxelShapes.func_197880_a()), bottom_ring.getOrDefault(direction, VoxelShapes.func_197880_a())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            return SHAPES.get(BlockEnderTank.getFacing(state))[0];
        }
        return VoxelShapes.func_197868_b();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.onBlockActivated(state, world, pos, player, hand, player.func_184586_b(hand), hit.func_216354_b());
    }

    public ActionResultType onBlockActivated(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, ItemStack heldItem, Direction face) {
        TileEntityEnderTank tankTile = this.getTile((IBlockReader)world, pos);
        if (tankTile == null) {
            return ActionResultType.PASS;
        }
        if (!heldItem.func_190926_b() && !(heldItem.func_77973_b() instanceof ItemEnderBucket) && tankTile.canUse(player)) {
            IFluidHandler tankHandler = tankTile.getEnderContainer().getTankFor(IFluidHandler.class);
            IFluidHandler containerHandler = CapabilityHelper.FLUIDS.getHandler(heldItem.func_77946_l().func_77979_a(1), face);
            if (tankHandler != null && containerHandler != null) {
                if (!world.field_72995_K) {
                    FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)tankHandler);
                }
                return ActionResultType.SUCCESS;
            }
        }
        if (!player.func_213453_ef()) {
            if (tankTile.lastClick <= System.currentTimeMillis()) {
                tankTile.lastClick = System.currentTimeMillis() + 200L;
                if (!world.field_72995_K && (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof BlockItem) && !heldItem.func_77973_b().getToolTypes(heldItem).contains(Values.WRENCH))) {
                    TankInfoHelper.sendTankInfo(player, tankTile);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (!heldItem.func_190926_b()) {
            DyeColor color;
            int subHit;
            if (tankTile.isPublic()) {
                boolean changed = false;
                if (Values.listPersonal.contains(heldItem.func_77973_b())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalTanks.get()).booleanValue()) {
                        changed = true;
                        if (!world.field_72995_K) {
                            tankTile.setOwner(player, heldItem.func_77946_l().func_77979_a(1));
                            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                        }
                    } else if (!world.field_72995_K) {
                        TankInfoHelper.sendError(player, "endertanks.tank.private.disabled");
                    }
                }
                if (!changed && Values.listTeam.contains(heldItem.func_77973_b())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamTanks.get()).booleanValue()) {
                        String teamID = Function.getPlayerTeamID((PlayerEntity)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            if (!world.field_72995_K) {
                                tankTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.func_77946_l().func_77979_a(1));
                                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                            }
                        } else if (!world.field_72995_K) {
                            TankInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else if (!world.field_72995_K) {
                        TankInfoHelper.sendError(player, "endertanks.tank.team.disabled");
                    }
                }
                if (changed) {
                    if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if (!tankTile.canEdit(player)) {
                return ActionResultType.SUCCESS;
            }
            short capacity = TankHelper.getCapacityInBuckets(tankTile.getEnderContainer());
            if (capacity < (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMax.get()) {
                int newValue = 0;
                if (Values.listSmallCap_Single.contains(heldItem.func_77973_b())) {
                    newValue = -1;
                    if (tankTile.applyItem(heldItem)) {
                        newValue = (Integer)Configuration.UPGRADE_SETTINGS.smallCapacity.get();
                    } else if (!world.field_72995_K) {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                }
                if (newValue == 0 && Values.listSmallCap_Multi.contains(heldItem.func_77973_b())) {
                    newValue = (Integer)Configuration.UPGRADE_SETTINGS.smallCapacity.get();
                }
                if (newValue == 0 && capacity + (Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get() <= (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMax.get()) {
                    if (Values.listLargeCap_Single.contains(heldItem.func_77973_b())) {
                        newValue = -1;
                        if (tankTile.applyItem(heldItem)) {
                            newValue = (Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get();
                        } else if (!world.field_72995_K) {
                            TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Values.listLargeCap_Multi.contains(heldItem.func_77973_b())) {
                        newValue = (Integer)Configuration.UPGRADE_SETTINGS.largeCapacity.get();
                    }
                }
                if (newValue > 0) {
                    if (!world.field_72995_K) {
                        TankHelper.setCapacityInBuckets(tankTile.getEnderContainer(), (short)(capacity + newValue));
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        TankInfoHelper.sendCapacityInfo(player, tankTile);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if (tankTile.getPumpUpgradeCount() < (Integer)Configuration.UPGRADE_SETTINGS.tankPumpMax.get()) {
                boolean upgrade_pump = false;
                if (Values.listPump_Single.contains(heldItem.func_77973_b())) {
                    if (tankTile.applyItem(heldItem)) {
                        upgrade_pump = true;
                    } else if (!world.field_72995_K) {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                } else if (Values.listPump_Multi.contains(heldItem.func_77973_b())) {
                    upgrade_pump = true;
                }
                if (upgrade_pump) {
                    if (!world.field_72995_K) {
                        tankTile.addPumpUpgrade(heldItem.func_77946_l().func_77979_a(1));
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        TankInfoHelper.sendPumpInfo(player, tankTile);
                        Function.syncTile((TileEntity)tankTile);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if (((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue() && (subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])SHAPES.get(state.func_177229_b((Property)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((Item)heldItem.func_77973_b())) != null && tankTile.doColorRing(color, player)) {
                if (!world.field_72995_K) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    world.func_195593_d(pos, (Block)this);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null && tile.canEdit(player)) {
            return super.func_180647_a(state, player, world, pos);
        }
        return -1.0f;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean isPowered = context.func_195991_k().func_175640_z(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityEnderTank tile = this.getTile((IBlockReader)world, pos);
        if (tile != null) {
            String code = StackHelper.getCode(stack);
            while (code.length() < 3) {
                code = "0" + code;
            }
            ItemStack personalItem = StackHelper.getPersonalItem(stack);
            tile.setCode(code);
            if (!personalItem.func_190926_b()) {
                tile.setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personalItem);
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighbor, BlockPos fromPos, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    private void updatePoweredState(BlockState state, World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            boolean isPowered = world.func_175640_z(pos);
            if ((Boolean)state.func_177229_b((Property)POWERED) != isPowered) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))), (boolean)false);
            }
            if (isPowered) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 20);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.updatePoweredState(state, (World)world, pos);
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            TileEntityEnderTank tankTile = this.getTile((IBlockReader)world, pos);
            if (tankTile != null) {
                Direction tankFacing = BlockEnderTank.getFacing(state);
                BlockPos fromPos = pos.func_177972_a(tankFacing.func_176734_d());
                BlockPos toPos = pos.func_177972_a(tankFacing);
                int pumpCapacity = tankTile.getPumpCapacity();
                EnderContainer enderContainer = tankTile.getEnderContainer();
                HandlerRegistry.getProviders().forEach((key, provider) -> {
                    ITankHandler<?> handler = enderContainer.getOrCreateHandler((String)key);
                    if (handler != null) {
                        handler.preformPumpAction((World)world, pos, tankFacing, fromPos, toPos, pumpCapacity, random);
                    }
                });
            }
            world.func_205220_G_().func_205360_a(pos, (Object)this, 20);
        }
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.func_180647_a(state, player, world, pos) > -1.0f;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (this.func_180647_a(state, player, (IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity builderTile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (builderTile instanceof TileEntityEnderTank) {
            ItemStack personal;
            TileEntityEnderTank tile = (TileEntityEnderTank)builderTile;
            Entity builderEntity = (Entity)builder.func_216019_b(LootParameters.field_216281_a);
            if (builderEntity != null && builderEntity.func_213453_ef() && (personal = tile.getPersonalItem()) != null) {
                drops.add(personal);
            }
            drops.addAll(tile.getPumpUpgrades());
        }
        return drops;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new ItemStack((IItemProvider)this);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            if (player != null && !player.func_213453_ef()) {
                if (tile.isTeam() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase("#" + Function.getPlayerTeamID((PlayerEntity)player)))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase(player.func_110124_au().toString()))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null);
        }
        return new ItemStack((IItemProvider)this);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            Direction facing = BlockEnderTank.getFacing(state);
            if (rotation == Rotation.CLOCKWISE_180) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
            int value = facing.ordinal() + (rotation == Rotation.CLOCKWISE_90 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.func_82600_a((int)value));
        }
        return state;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return CapabilityHelper.COMPARATOR.getInputOverride((IWorld)world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderTank tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((IBlockReader)data.world, data.pos)) != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static Direction getFacing(BlockState state) {
        Direction facing;
        try {
            facing = (Direction)state.func_177229_b((Property)FACING);
        }
        catch (Exception e) {
            facing = Direction.DOWN;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static boolean isPowered(BlockState state) {
        boolean powered;
        try {
            powered = (Boolean)state.func_177229_b((Property)POWERED);
        }
        catch (Exception e) {
            powered = false;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.POWERED' not found in provided BlockState, returning 'false'. Provided BlockState: " + state);
        }
        return powered;
    }

    public static enum EnumType implements IStringSerializable
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

