/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.AbstractFurnaceContainer;
import net.minecraft.inventory.container.BlastFurnaceContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.inventory.container.SmokerContainer;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.type.IFurnaceProvider;
import top.theillusivec4.polymorph.api.type.IPersistentSelector;
import top.theillusivec4.polymorph.common.capability.FurnaceSelector;

public class SelectorCapability {
    public static void register() {
        PolymorphApi.getInstance().addEntityProvider(tileEntity -> {
            if (tileEntity instanceof AbstractFurnaceTileEntity) {
                return new FurnaceSelector((AbstractFurnaceTileEntity)tileEntity);
            }
            return null;
        }, container -> {
            if (container instanceof AbstractFurnaceContainer) {
                return new SimpleFurnaceProvider((Container)container);
            }
            return null;
        });
        CapabilityManager.INSTANCE.register(IPersistentSelector.class, (Capability.IStorage)new Capability.IStorage<IPersistentSelector>(){

            @Nonnull
            public INBT writeNBT(Capability<IPersistentSelector> capability, IPersistentSelector instance, Direction side) {
                CompoundNBT nbt = new CompoundNBT();
                instance.getSelectedRecipe().ifPresent(recipe -> nbt.func_74778_a("SelectedRecipe", recipe.func_199560_c().toString()));
                return nbt;
            }

            public void readNBT(Capability<IPersistentSelector> capability, IPersistentSelector instance, Direction side, INBT nbt) {
                CompoundNBT tag;
                if (nbt instanceof CompoundNBT && (tag = (CompoundNBT)nbt).func_74764_b("SelectedRecipe")) {
                    instance.setSavedRecipe(tag.func_74779_i("SelectedRecipe"));
                }
            }
        }, () -> new DefaultSelector());
    }

    private static class DefaultSelector
    implements IPersistentSelector {
        private DefaultSelector() {
        }

        @Override
        public Optional<IRecipe<?>> fetchRecipe(World world) {
            return Optional.empty();
        }

        @Override
        public IRecipeType<? extends IRecipe<?>> getRecipeType() {
            return null;
        }

        @Nonnull
        public Optional<IRecipe<?>> getSelectedRecipe() {
            return Optional.empty();
        }

        @Override
        public void setSavedRecipe(String recipe) {
        }

        @Override
        public void setSelectedRecipe(IRecipe<?> recipe) {
        }

        @Override
        public TileEntity getParent() {
            return null;
        }
    }

    private static class SimpleFurnaceProvider
    implements IFurnaceProvider {
        final Container container;
        final IInventory input;
        final IRecipeType<? extends AbstractCookingRecipe> recipeType;

        public SimpleFurnaceProvider(Container container) {
            this.container = container;
            this.input = ((Slot)container.field_75151_b.get((int)0)).field_75224_c;
            this.recipeType = this.getRecipeType();
        }

        private IRecipeType<? extends AbstractCookingRecipe> getRecipeType() {
            if (this.container instanceof SmokerContainer) {
                return IRecipeType.field_222152_d;
            }
            if (this.container instanceof BlastFurnaceContainer) {
                return IRecipeType.field_222151_c;
            }
            return IRecipeType.field_222150_b;
        }

        @Override
        @Nonnull
        public Container getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public IInventory getInventory() {
            return this.input;
        }

        @Override
        @Nonnull
        public List<? extends AbstractCookingRecipe> getRecipes(World world, RecipeManager recipeManager) {
            return recipeManager.func_215370_b(this.recipeType, this.getInventory(), world);
        }

        @Override
        @Nonnull
        public Slot getOutputSlot() {
            return (Slot)this.container.field_75151_b.get(2);
        }
    }
}

