/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.AbstractFurnaceContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.reflect.FieldUtils;
import top.theillusivec4.polymorph.Polymorph;
import top.theillusivec4.polymorph.api.type.IPersistentSelector;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.common.network.server.SPacketHighlightRecipe;
import top.theillusivec4.polymorph.mixin.core.AbstractFurnaceContainerMixin;

public class FurnaceSelector
implements IPersistentSelector {
    private final AbstractFurnaceTileEntity parent;
    private AbstractCookingRecipe selectedRecipe;
    private ItemStack lastFailedInput = ItemStack.field_190927_a;
    private String savedRecipe = "";

    public FurnaceSelector(AbstractFurnaceTileEntity tileEntity) {
        this.parent = tileEntity;
    }

    @Override
    public Optional<IRecipe<?>> fetchRecipe(World world) {
        Optional<IRecipe<?>> maybeRecipe;
        ItemStack input = this.parent.func_70301_a(0);
        if (input == this.lastFailedInput) {
            return Optional.empty();
        }
        if (!this.savedRecipe.isEmpty()) {
            Optional saved = world.func_199532_z().func_215367_a(new ResourceLocation(this.savedRecipe));
            if (!saved.isPresent() || !((IRecipe)saved.get()).func_77569_a((IInventory)this.parent, world)) {
                this.savedRecipe = "";
            } else {
                this.setSelectedRecipe((IRecipe)saved.get());
                this.savedRecipe = "";
                return saved;
            }
        }
        if (!(maybeRecipe = world.func_199532_z().func_199510_b().stream().filter(val -> val.func_222127_g() == this.getRecipeType()).flatMap(val -> Util.func_215081_a((Optional)this.getRecipeType().func_222148_a(val, world, (IInventory)this.parent))).min(Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a())).map(val -> {
            this.setSelectedRecipe((IRecipe<?>)val);
            return val;
        })).isPresent()) {
            this.lastFailedInput = input;
        }
        return maybeRecipe;
    }

    @Override
    public IRecipeType<? extends IRecipe<?>> getRecipeType() {
        if (this.parent instanceof SmokerTileEntity) {
            return IRecipeType.field_222152_d;
        }
        if (this.parent instanceof BlastFurnaceTileEntity) {
            return IRecipeType.field_222151_c;
        }
        return IRecipeType.field_222150_b;
    }

    @Nonnull
    public Optional<IRecipe<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSavedRecipe(String recipe) {
        this.savedRecipe = recipe;
    }

    @Override
    public void setSelectedRecipe(IRecipe<?> recipe) {
        this.selectedRecipe = (AbstractCookingRecipe)recipe;
        World world = this.parent.func_145831_w();
        if (world instanceof ServerWorld) {
            if (Polymorph.isFastFurnaceLoaded) {
                try {
                    FieldUtils.writeField((Object)this.parent, (String)"curRecipe", (Object)this.selectedRecipe, (boolean)true);
                }
                catch (IllegalAccessException e) {
                    Polymorph.LOGGER.error("Error accessing curRecipe from FastFurnace!");
                }
                catch (IllegalArgumentException e) {
                    Polymorph.LOGGER.debug("Cannot find FastFurnace, skipping field override!");
                }
            }
            ((ServerWorld)world).func_217369_A().forEach(player -> {
                if (player.field_71070_bA instanceof AbstractFurnaceContainer && ((AbstractFurnaceContainerMixin)player.field_71070_bA).getFurnaceInventory() == this.parent) {
                    NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketHighlightRecipe(recipe.func_199560_c().toString()));
                }
            });
        }
    }

    @Override
    public TileEntity getParent() {
        return this.parent;
    }
}

