/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.items.ItemHandlerHelper;
import tfar.dankstorage.container.PortableDankContainer;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.Mode;
import tfar.dankstorage.utils.Utils;

public class MixinEvents {
    public static boolean interceptItem(PlayerInventory inv, ItemStack incoming) {
        PlayerEntity player = inv.field_70458_d;
        if (player.field_71070_bA instanceof PortableDankContainer) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack possibleDank = inv.func_70301_a(i);
            if (!(possibleDank.func_77973_b() instanceof DankItem) || !MixinEvents.onItemPickup(player, incoming, possibleDank)) continue;
            return true;
        }
        return false;
    }

    public static boolean onItemPickup(PlayerEntity player, ItemStack pickup, ItemStack dank) {
        int i;
        Mode mode = Utils.getMode(dank);
        if (mode == Mode.normal) {
            return false;
        }
        PortableDankHandler inv = Utils.getHandler(dank);
        int count = pickup.func_190916_E();
        boolean oredict = Utils.oredict(dank);
        ArrayList<ItemStack> existing = new ArrayList<ItemStack>();
        for (i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean exists = false;
            for (ItemStack stack1 : existing) {
                if (!MixinEvents.areItemStacksCompatible(stack, stack1, oredict)) continue;
                exists = true;
            }
            if (exists) continue;
            existing.add(stack.func_77946_l());
        }
        switch (mode) {
            case pickup_all: {
                for (i = 0; i < inv.getSlots(); ++i) {
                    MixinEvents.allPickup(inv, i, pickup, false, oredict);
                }
                break;
            }
            case filtered_pickup: {
                for (i = 0; i < inv.getSlots(); ++i) {
                    MixinEvents.filteredPickup(inv, i, pickup, false, oredict, existing);
                }
                break;
            }
            case void_pickup: {
                for (i = 0; i < inv.getSlots(); ++i) {
                    MixinEvents.voidPickup(inv, i, pickup, false, oredict, existing);
                }
                break;
            }
        }
        pickup.func_190920_e(pickup.func_190916_E());
        if (pickup.func_190916_E() != count) {
            dank.func_190915_d(5);
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            inv.save();
        }
        return pickup.func_190926_b();
    }

    public static void voidPickup(PortableDankHandler inv, int slot, ItemStack toInsert, boolean simulate, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (MixinEvents.doesItemStackExist(toInsert, filter, oredict) && MixinEvents.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.getSlotLimit(slot);
            int total = toInsert.func_190916_E() + existing.func_190916_E();
            if (!simulate) {
                inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)Math.min(total, stackLimit)));
                toInsert.func_190920_e(0);
            }
        }
    }

    public static void allPickup(PortableDankHandler inv, int slot, ItemStack toInsert, boolean simulate, boolean oredict) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            int stackLimit = inv.getSlotLimit(slot);
            int total = toInsert.func_190916_E();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)toInsert.func_77946_l());
                }
                toInsert.func_190920_e(0);
            } else {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
                }
                toInsert.func_190920_e(remainder);
            }
            return;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)toInsert, (ItemStack)existing) || oredict && Utils.areItemStacksConvertible(toInsert, existing)) {
            int stackLimit = inv.getSlotLimit(slot);
            int total = toInsert.func_190916_E() + existing.func_190916_E();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)total));
                }
                toInsert.func_190920_e(0);
            } else {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
                }
                toInsert.func_190920_e(remainder);
            }
        }
    }

    public static void filteredPickup(PortableDankHandler inv, int slot, ItemStack toInsert, boolean simulate, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (existing.func_190926_b() && MixinEvents.doesItemStackExist(toInsert, filter, oredict)) {
            int stackLimit = inv.getSlotLimit(slot);
            int total = toInsert.func_190916_E();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)toInsert.func_77946_l());
                }
                toInsert.func_190920_e(0);
            } else {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
                }
                toInsert.func_190920_e(remainder);
            }
            return;
        }
        if (MixinEvents.doesItemStackExist(toInsert, filter, oredict) && MixinEvents.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.getSlotLimit(slot);
            int total = toInsert.func_190916_E() + existing.func_190916_E();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)total));
                }
                toInsert.func_190920_e(0);
            } else {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
                }
                toInsert.func_190920_e(remainder);
            }
        }
    }

    public static boolean areItemStacksCompatible(ItemStack stackA, ItemStack stackB, boolean oredict) {
        return oredict ? ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) || Utils.areItemStacksConvertible(stackA, stackB) : ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean doesItemStackExist(ItemStack stack, List<ItemStack> filter, boolean oredict) {
        for (ItemStack filterStack : filter) {
            if (!MixinEvents.areItemStacksCompatible(stack, filterStack, oredict)) continue;
            return true;
        }
        return false;
    }
}

