/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.block.DockBlock;
import tfar.dankstorage.container.DockContainer;
import tfar.dankstorage.inventory.DankHandler;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Utils;

public class DockBlockEntity
extends TileEntity
implements INameable,
INamedContainerProvider {
    public int numPlayersUsing = 0;
    protected ITextComponent customName;
    public int mode = 0;
    public int selectedSlot;
    public final IIntArray array = new IIntArray(){

        public int func_221476_a(int index) {
            return ((DockBlockEntity)DockBlockEntity.this).handler.lockedSlots[index];
        }

        public void func_221477_a(int index, int value) {
            ((DockBlockEntity)DockBlockEntity.this).handler.lockedSlots[index] = value;
        }

        public int func_221478_a() {
            return ((DockBlockEntity)DockBlockEntity.this).handler.lockedSlots.length;
        }
    };
    private final DankHandler handler = new DankHandler(DankStats.zero){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DockBlockEntity.this.func_70296_d();
        }

        @Override
        public boolean canPlayerUse(PlayerEntity player) {
            if (DockBlockEntity.this.field_145850_b.func_175625_s(DockBlockEntity.this.field_174879_c) != DockBlockEntity.this) {
                return false;
            }
            return !(player.func_70092_e((double)DockBlockEntity.this.field_174879_c.func_177958_n() + 0.5, (double)DockBlockEntity.this.field_174879_c.func_177956_o() + 0.5, (double)DockBlockEntity.this.field_174879_c.func_177952_p() + 0.5) > 64.0);
        }

        @Override
        public void onOpen(PlayerEntity player) {
            super.onOpen(player);
            if (!player.func_175149_v()) {
                if (DockBlockEntity.this.numPlayersUsing < 0) {
                    DockBlockEntity.this.numPlayersUsing = 0;
                }
                ++DockBlockEntity.this.numPlayersUsing;
            }
        }

        @Override
        public void onClose(PlayerEntity player) {
            super.onClose(player);
            if (!player.func_175149_v()) {
                --DockBlockEntity.this.numPlayersUsing;
            }
        }
    };
    public LazyOptional<IItemHandler> optional = LazyOptional.of(() -> this.handler).cast();

    public DockBlockEntity() {
        super(DankStorage.Objects.dank_tile);
    }

    public DankHandler getHandler() {
        return this.handler;
    }

    public int getComparatorSignal() {
        return this.handler.calcRedstone();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.mode = compound.func_74762_e("mode");
        this.selectedSlot = compound.func_74762_e("selectedSlot");
        if (compound.func_74764_b("inv")) {
            this.handler.setStats(DankStats.fromInt((Integer)state.func_177229_b((Property)DockBlock.TIER)));
            this.handler.deserializeNBT(compound.func_74775_l("inv"));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName")));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("mode", this.mode);
        tag.func_74768_a("selectedSlot", this.selectedSlot);
        tag.func_218657_a("inv", (INBT)this.handler.serializeNBT());
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.field_145850_b.field_72995_K) {
                return this.optional.cast();
            }
            return LazyOptional.of(() -> new DankHandler(DankStats.values()[(Integer)this.func_195044_w().func_177229_b((Property)DockBlock.TIER)])).cast();
        }
        return super.getCapability(capability, facing);
    }

    public void setCustomName(ITextComponent text) {
        this.customName = text;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    ITextComponent getDefaultName() {
        return new TranslationTextComponent("container.dankstorage.dank_" + this.func_195044_w().func_177229_b((Property)DockBlock.TIER));
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity p_createMenu_3_) {
        switch ((Integer)this.func_195044_w().func_177229_b((Property)DockBlock.TIER)) {
            case 1: {
                return DockContainer.dock1s(id, inv, this.handler, this.array);
            }
            case 2: {
                return DockContainer.dock2s(id, inv, this.handler, this.array);
            }
            case 3: {
                return DockContainer.dock3s(id, inv, this.handler, this.array);
            }
            case 4: {
                return DockContainer.dock4s(id, inv, this.handler, this.array);
            }
            case 5: {
                return DockContainer.dock5s(id, inv, this.handler, this.array);
            }
            case 6: {
                return DockContainer.dock6s(id, inv, this.handler, this.array);
            }
            case 7: {
                return DockContainer.dock7s(id, inv, this.handler, this.array);
            }
        }
        return null;
    }

    public void removeTank() {
        ItemStack stack = this.removeTankWithoutItemSpawn();
        ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack);
        this.field_145850_b.func_217376_c((Entity)entity);
    }

    public ItemStack removeTankWithoutItemSpawn() {
        int tier = (Integer)this.func_195044_w().func_177229_b((Property)DockBlock.TIER);
        CompoundNBT nbt = this.handler.serializeNBT();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)DockBlock.TIER, (Comparable)Integer.valueOf(0)));
        this.handler.setStats(DankStats.zero);
        this.optional.invalidate();
        ItemStack stack = new ItemStack((IItemProvider)Utils.getItemFromTier(tier));
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_145748_c_());
        }
        this.setCustomName(null);
        stack.func_196082_o().func_218657_a("inv", (INBT)nbt);
        return stack;
    }

    public void addTank(ItemStack tank) {
        if (tank.func_77973_b() instanceof DankItem) {
            DankStats tier = ((DankItem)tank.func_77973_b()).tier;
            BlockState oldState = this.func_195044_w();
            BlockState newState = (BlockState)oldState.func_206870_a((Property)DockBlock.TIER, (Comparable)Integer.valueOf(tier.ordinal()));
            this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            this.handler.setStats(tier);
            this.handler.deserializeNBT(tank.func_196082_o().func_74775_l("inv"));
            this.optional = LazyOptional.of(() -> this.handler);
            if (tank.func_82837_s()) {
                this.setCustomName(tank.func_200301_q());
            }
            tank.func_190918_g(1);
            this.field_145850_b.func_195593_d(this.field_174879_c, newState.func_177230_c());
        }
    }

    public void upgrade(DankStats to) {
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)DockBlock.TIER, (Comparable)Integer.valueOf(to.ordinal())));
        this.handler.setStats(to);
    }
}

