/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.init;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.block.LootrInventoryBlock;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.LootrTrappedChestBlock;
import noobanidus.mods.lootr.block.TrophyBlock;
import noobanidus.mods.lootr.block.tile.LootrShulkerTileEntity;

@Mod.EventBusSubscriber(modid="lootr", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static LootrBarrelBlock BARREL = new LootrBarrelBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
    public static LootrChestBlock CHEST = new LootrChestBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
    public static LootrTrappedChestBlock TRAPPED_CHEST = new LootrTrappedChestBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
    public static LootrInventoryBlock INVENTORY = new LootrInventoryBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
    private static final AbstractBlock.IPositionPredicate posPredicate = (state, level, pos) -> {
        TileEntity tileentity = level.func_175625_s(pos);
        if (!(tileentity instanceof LootrShulkerTileEntity)) {
            return true;
        }
        LootrShulkerTileEntity shulkerboxtileentity = (LootrShulkerTileEntity)tileentity;
        return shulkerboxtileentity.isClosed();
    };
    public static LootrShulkerBlock SHULKER = new LootrShulkerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_215711_w).func_200943_b(2.5f).func_208770_d().func_226896_b_().func_235842_b_(posPredicate).func_235847_c_(posPredicate));
    public static Set<Block> LOOT_CONTAINERS = Sets.newHashSet((Object[])new Block[]{CHEST, BARREL, TRAPPED_CHEST, SHULKER, INVENTORY});
    public static Block TROPHY = new TrophyBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(15.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_226896_b_().func_235838_a_(o -> 15));

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        LOOT_CONTAINERS.forEach(o -> event.getRegistry().register((IForgeRegistryEntry)o));
        event.getRegistry().register((IForgeRegistryEntry)TROPHY);
    }

    static {
        BARREL.setRegistryName("lootr", "lootr_barrel");
        CHEST.setRegistryName("lootr", "lootr_chest");
        TRAPPED_CHEST.setRegistryName("lootr", "lootr_trapped_chest");
        INVENTORY.setRegistryName("lootr", "lootr_inventory");
        SHULKER.setRegistryName("lootr", "lootr_shulker");
        TROPHY.setRegistryName("lootr", "trophy");
    }
}

