/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.data.AdvancementData;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.data.TickingData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class DataStorage {
    public static final String ID = "Lootr-AdvancementData";
    public static final String SCORED = "Lootr-ScoreData";
    public static final String DECAY = "Lootr-DecayData";
    public static final String REFRESH = "Lootr-RefreshData";

    public static boolean isAwarded(UUID player, UUID tileId) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        AdvancementData data = (AdvancementData)manager.func_215752_a(() -> new AdvancementData(ID), ID);
        return data.contains(player, tileId);
    }

    public static void award(UUID player, UUID tileId) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        AdvancementData data = (AdvancementData)manager.func_215752_a(() -> new AdvancementData(ID), ID);
        data.add(player, tileId);
        data.func_76185_a();
        manager.func_212775_b();
    }

    public static boolean isScored(UUID player, UUID tileId) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        AdvancementData data = (AdvancementData)manager.func_215752_a(() -> new AdvancementData(SCORED), SCORED);
        return data.contains(player, tileId);
    }

    public static void score(UUID player, UUID tileId) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        AdvancementData data = (AdvancementData)manager.func_215752_a(() -> new AdvancementData(SCORED), SCORED);
        data.add(player, tileId);
        data.func_76185_a();
        manager.func_212775_b();
    }

    public static int getDecayValue(UUID id) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(DECAY), DECAY);
        return data.getValue(id);
    }

    public static boolean isDecayed(UUID id) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(DECAY), DECAY);
        return data.isDone(id);
    }

    public static void setDecaying(UUID id, int decay) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(DECAY), DECAY);
        data.setValue(id, decay);
        data.func_76185_a();
        manager.func_212775_b();
    }

    public static void removeDecayed(UUID id) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(DECAY), DECAY);
        if (data.removeDone(id) != -1) {
            data.func_76185_a();
            manager.func_212775_b();
        }
    }

    public static void doDecay() {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(DECAY), DECAY);
        if (data.tick()) {
            data.func_76185_a();
            manager.func_212775_b();
        }
    }

    public static int getRefreshValue(UUID id) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(REFRESH), REFRESH);
        return data.getValue(id);
    }

    public static boolean isRefreshed(UUID id) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(REFRESH), REFRESH);
        return data.isDone(id);
    }

    public static void setRefreshing(UUID id, int decay) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(REFRESH), REFRESH);
        data.setValue(id, decay);
        data.func_76185_a();
        manager.func_212775_b();
    }

    public static void removeRefreshed(UUID id) {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(REFRESH), REFRESH);
        if (data.removeDone(id) != -1) {
            data.func_76185_a();
            manager.func_212775_b();
        }
    }

    public static void doRefresh() {
        DimensionSavedDataManager manager = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x();
        TickingData data = (TickingData)manager.func_215752_a(() -> new TickingData(REFRESH), REFRESH);
        if (data.tick()) {
            data.func_76185_a();
            manager.func_212775_b();
        }
    }

    public static ServerWorld getServerWorld() {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
    }

    public static ChestData getInstancePos(ServerWorld world, BlockPos pos) {
        RegistryKey dimension = world.func_234923_W_();
        return (ChestData)DataStorage.getServerWorld().func_217481_x().func_215753_b(() -> new ChestData((RegistryKey<World>)dimension, pos), ChestData.OLD_ID((RegistryKey<World>)dimension, pos));
    }

    public static ChestData getInstanceUuid(ServerWorld world, UUID id) {
        RegistryKey dimension = world.func_234923_W_();
        return (ChestData)DataStorage.getServerWorld().func_217481_x().func_215752_a(() -> new ChestData((RegistryKey<World>)dimension, id), ChestData.ID((RegistryKey<World>)dimension, id));
    }

    public static ChestData getInstance(ServerWorld world, UUID id) {
        return (ChestData)DataStorage.getServerWorld().func_217481_x().func_215752_a(() -> new ChestData(id), ChestData.ENTITY(id));
    }

    public static ChestData getInstanceInventory(ServerWorld world, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        RegistryKey dimension = world.func_234923_W_();
        return (ChestData)DataStorage.getServerWorld().func_217481_x().func_215752_a(() -> new ChestData((RegistryKey<World>)dimension, id, customId, base), ChestData.REF_ID((RegistryKey<World>)dimension, id));
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, UUID uuid, BlockPos pos, ServerPlayerEntity player, LockableLootTileEntity tile, LootFiller filler) {
        SpecialChestInventory inventory;
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        ChestData data = DataStorage.getInstanceUuid((ServerWorld)world, uuid);
        ChestData oldData = DataStorage.getInstancePos((ServerWorld)world, pos);
        if (oldData != null) {
            Map<UUID, SpecialChestInventory> inventories = data.getInventories();
            inventories.putAll(oldData.getInventories());
            data.setInventories(inventories);
            oldData.clear();
            oldData.func_76185_a();
        }
        if ((inventory = data.getInventory(player, pos)) == null) {
            inventory = data.createInventory(player, filler, tile);
            inventory.setBlockPos(pos);
        }
        return inventory;
    }

    public static void refreshInventory(World world, UUID uuid, ServerPlayerEntity player) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return;
        }
        ChestData data = DataStorage.getInstanceUuid((ServerWorld)world, uuid);
        data.clear();
        data.func_76185_a();
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, UUID uuid, NonNullList<ItemStack> base, ServerPlayerEntity player, BlockPos pos, LockableLootTileEntity tile) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        ChestData data = DataStorage.getInstanceInventory((ServerWorld)world, uuid, null, base);
        SpecialChestInventory inventory = data.getInventory(player, pos);
        if (inventory == null) {
            inventory = data.createInventory(player, data.customInventory(), tile);
            inventory.setBlockPos(pos);
        }
        return inventory;
    }

    @Nullable
    public static void refreshInventory(World world, UUID uuid, NonNullList<ItemStack> base, ServerPlayerEntity player) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return;
        }
        ChestData data = DataStorage.getInstanceInventory((ServerWorld)world, uuid, null, base);
        data.clear();
        data.func_76185_a();
    }

    public static boolean clearInventories(ServerPlayerEntity player) {
        return DataStorage.clearInventories(player.func_110124_au());
    }

    public static boolean clearInventories(UUID uuid) {
        ServerWorld world = DataStorage.getServerWorld();
        DimensionSavedDataManager data = world.func_217481_x();
        Path dataPath = world.func_73046_m().func_240776_a_(new FolderName("data"));
        ArrayList ids = new ArrayList();
        try {
            Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);
            Object object = null;
            try {
                paths.forEach(o -> {
                    String name;
                    if (Files.isRegularFile(o, new LinkOption[0]) && (name = o.getFileName().toString()).startsWith("Lootr-") && !name.endsWith("Data.dat")) {
                        ids.add(name.replace(".dat", ""));
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (paths != null) {
                    if (object != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        int cleared = 0;
        for (String id : ids) {
            ChestData chestData = (ChestData)data.func_215753_b(() -> null, id);
            if (chestData == null || !chestData.clearInventory(uuid)) continue;
            ++cleared;
            chestData.func_76185_a();
        }
        data.func_212775_b();
        Lootr.LOG.info("Cleared " + cleared + " inventories for play UUID " + uuid.toString());
        return cleared != 0;
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, LootrChestMinecartEntity cart, ServerPlayerEntity player, LootFiller filler) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        ChestData data = DataStorage.getInstance((ServerWorld)world, cart.func_110124_au());
        SpecialChestInventory inventory = data.getInventory(player, null);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, null);
        }
        return inventory;
    }

    @Nullable
    public static void refreshInventory(World world, LootrChestMinecartEntity cart, ServerPlayerEntity player) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return;
        }
        ChestData data = DataStorage.getInstance((ServerWorld)world, cart.func_110124_au());
        data.clear();
        data.func_76185_a();
    }

    public static void wipeInventory(ServerWorld world, BlockPos pos) {
        ServerWorld serverWorld = DataStorage.getServerWorld();
        RegistryKey dimension = world.func_234923_W_();
        DimensionSavedDataManager manager = serverWorld.func_217481_x();
        String id = ChestData.OLD_ID((RegistryKey<World>)dimension, pos);
        if (!manager.field_212778_c.containsKey(id)) {
            return;
        }
        ChestData data = (ChestData)manager.func_215753_b(() -> null, id);
        if (data != null) {
            data.clear();
            data.func_76185_a();
        }
    }

    public static void deleteLootChest(ServerWorld world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        DataStorage.wipeInventory(world, pos);
        DataStorage.getServerWorld().func_217481_x().func_212775_b();
    }
}

