/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModTiles;

public class LootrShulkerTileEntity
extends LockableLootTileEntity
implements ILootTile,
ITickableTileEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    private final NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int openCount;
    private ShulkerBoxTileEntity.AnimationStatus animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private UUID tileId = null;
    private boolean opened;

    public LootrShulkerTileEntity() {
        super(ModTiles.LOOK_SHULKER);
    }

    public void func_73660_a() {
        this.updateAnimation();
        if (this.animationStatus == ShulkerBoxTileEntity.AnimationStatus.OPENING || this.animationStatus == ShulkerBoxTileEntity.AnimationStatus.CLOSING) {
            this.moveCollidedEntities();
        }
    }

    protected void updateAnimation() {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.moveCollidedEntities();
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.OPENED;
                this.progress = 1.0f;
                this.doNeighborUpdates();
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                this.doNeighborUpdates();
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public ShulkerBoxTileEntity.AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox(BlockState pState) {
        return this.getBoundingBox((Direction)pState.func_177229_b((Property)ShulkerBoxBlock.field_190957_a));
    }

    public AxisAlignedBB getBoundingBox(Direction p_190587_1_) {
        float f = this.getProgress(1.0f);
        return VoxelShapes.func_197868_b().func_197752_a().func_72321_a((double)(0.5f * f * (float)p_190587_1_.func_82601_c()), (double)(0.5f * f * (float)p_190587_1_.func_96559_d()), (double)(0.5f * f * (float)p_190587_1_.func_82599_e()));
    }

    private AxisAlignedBB getTopBoundingBox(Direction p_190588_1_) {
        Direction direction = p_190588_1_.func_176734_d();
        return this.getBoundingBox(p_190588_1_).func_191195_a((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
    }

    private void moveCollidedEntities() {
        Direction direction;
        AxisAlignedBB axisalignedbb;
        List list;
        BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockstate.func_177230_c() instanceof ShulkerBoxBlock && !(list = this.field_145850_b.func_72839_b(null, axisalignedbb = this.getTopBoundingBox(direction = (Direction)blockstate.func_177229_b((Property)ShulkerBoxBlock.field_190957_a)).func_186670_a(this.field_174879_c))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                switch (direction.func_176740_k()) {
                    case X: {
                        d0 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                        d2 += 0.01;
                    }
                }
                entity.func_213315_a(MoverType.SHULKER_BOX, new Vector3d(d0 * (double)direction.func_82601_c(), d1 * (double)direction.func_96559_d(), d2 * (double)direction.func_82599_e()));
            }
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_145842_c(int pId, int pType) {
        if (pId == 1) {
            this.openCount = pType;
            if (pType == 0) {
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSING;
                this.doNeighborUpdates();
            }
            if (pType == 1) {
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.OPENING;
                this.doNeighborUpdates();
            }
            return true;
        }
        return super.func_145842_c(pId, pType);
    }

    private void doNeighborUpdates() {
        this.func_195044_w().func_235734_a_((IWorld)this.func_145831_w(), this.func_174877_v(), 3);
    }

    public void func_174889_b(PlayerEntity pPlayer) {
        if (!pPlayer.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.openCount);
            if (this.openCount == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_174886_c(PlayerEntity pPlayer) {
        if (!pPlayer.func_175149_v()) {
            --this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.openers.add(pPlayer.func_110124_au());
            this.updatePacketViaState();
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.shulkerBox");
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
            this.func_189404_a(this.savedLootTable, this.seed);
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.func_74764_b("LootrOpeners")) {
            ListNBT openers = compound.func_150295_c("LootrOpeners", 11);
            this.openers.clear();
            for (INBT item : openers) {
                this.openers.add(NBTUtil.func_186860_b((INBT)item));
            }
        }
        this.requestModelDataUpdate();
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootBarrel_table", this.savedLootTable.toString());
            compound.func_74778_a("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootBarrel_seed", this.seed);
            compound.func_74772_a("LootTableSeed", this.seed);
        }
        compound.func_186854_a("tileId", this.getTileId());
        ListNBT list = new ListNBT();
        for (UUID opener : this.openers) {
            list.add((Object)NBTUtil.func_240626_a_((UUID)opener));
        }
        compound.func_218657_a("LootrOpeners", (INBT)list);
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.itemStacks;
    }

    protected void func_199721_a(NonNullList<ItemStack> pItems) {
    }

    public float getProgress(float pPartialTicks) {
        return MathHelper.func_219799_g((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        super.func_189404_a(lootTableIn, seedIn);
    }

    public void func_184281_d(@Nullable PlayerEntity pPlayer) {
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    protected Container func_213906_a(int pId, PlayerInventory pPlayer) {
        return new ShulkerBoxContainer(pId, pPlayer, (IInventory)this);
    }

    public boolean isClosed() {
        return this.animationStatus == ShulkerBoxTileEntity.AnimationStatus.CLOSED;
    }

    @Override
    public void fillWithLoot(PlayerEntity player, IInventory inventory, ResourceLocation overrideTable, long seed) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.field_186464_a) {
                Lootr.LOG.error("Unable to fill loot shulker in " + this.field_145850_b.func_234923_W_() + " at " + this.field_174879_c + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("lootr.message.invalid_table", new Object[]{(overrideTable != null ? overrideTable : this.savedLootTable).toString()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED).func_240713_a_(Boolean.valueOf(true))), Util.field_240973_b_);
                }
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)player, overrideTable != null ? overrideTable : this.field_184284_m);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)this.field_174879_c)).func_216016_a((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a(inventory, builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    @Override
    public void updatePacketViaState() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 8);
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(ModBlocks.SHULKER.func_176223_P(), pkt.func_148857_g());
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }
}

