/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noobanidus.mods.lootr.block.tile.LootrShulkerTileEntity;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.init.ModItems;
import noobanidus.mods.lootr.util.ChestUtil;

public class LootrShulkerBlock
extends ShulkerBoxBlock {
    public LootrShulkerBlock(AbstractBlock.Properties pProperties) {
        super(DyeColor.YELLOW, pProperties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_190957_a, (Comparable)Direction.UP));
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new LootrShulkerTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit) {
        if (pLevel.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (pPlayer.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = pLevel.func_175625_s(pPos);
        if (tileentity instanceof LootrShulkerTileEntity) {
            boolean flag;
            LootrShulkerTileEntity shulkerboxtileentity = (LootrShulkerTileEntity)tileentity;
            if (shulkerboxtileentity.getAnimationStatus() == ShulkerBoxTileEntity.AnimationStatus.CLOSED) {
                Direction direction = (Direction)pState.func_177229_b((Property)field_190957_a);
                flag = pLevel.func_226664_a_(ShulkerAABBHelper.func_233539_a_((BlockPos)pPos, (Direction)direction));
            } else {
                flag = true;
            }
            if (flag) {
                if (pPlayer.func_225608_bj_()) {
                    ChestUtil.handleLootSneak((Block)this, pLevel, pPos, pPlayer);
                } else {
                    ChestUtil.handleLootChest((Block)this, pLevel, pPos, pPlayer);
                }
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_176208_a(World pLevel, BlockPos pPos, BlockState pState, PlayerEntity pPlayer) {
        pLevel.func_217378_a(pPlayer, 2001, pPos, LootrShulkerBlock.func_196246_j((BlockState)pState));
        if (this.func_203417_a((ITag)BlockTags.field_232883_ay_)) {
            PiglinTasks.func_234478_a_((PlayerEntity)pPlayer, (boolean)false);
        }
    }

    public List<ItemStack> func_220076_a(BlockState pState, LootContext.Builder pBuilder) {
        ResourceLocation resourcelocation = this.func_220068_i();
        if (resourcelocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootcontext = pBuilder.func_216015_a(LootParameters.field_216287_g, (Object)pState).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld serverworld = lootcontext.func_202879_g();
        LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        return loottable.func_216113_a(lootcontext);
    }

    public void func_196243_a(BlockState pState, World pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.func_177230_c() != pNewState.func_177230_c() && pLevel instanceof ServerWorld) {
            DataStorage.deleteLootChest((ServerWorld)pLevel, pPos);
        }
        if (!pState.func_203425_a(pNewState.func_177230_c())) {
            TileEntity tileentity = pLevel.func_175625_s(pPos);
            if (tileentity instanceof LootrShulkerTileEntity) {
                pLevel.func_175666_e(pPos, pState.func_177230_c());
            }
            if (!(!pState.hasTileEntity() || pState.func_203425_a(pNewState.func_177230_c()) && pNewState.hasTileEntity())) {
                pLevel.func_175713_t(pPos);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack pStack, @Nullable IBlockReader pLevel, List<ITextComponent> pTooltip, ITooltipFlag pFlag) {
    }

    public VoxelShape func_220053_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, ISelectionContext pContext) {
        TileEntity tileentity = pLevel.func_175625_s(pPos);
        return tileentity instanceof LootrShulkerTileEntity ? VoxelShapes.func_197881_a((AxisAlignedBB)((LootrShulkerTileEntity)tileentity).getBoundingBox(pState)) : VoxelShapes.func_197868_b();
    }

    public boolean func_149740_M(BlockState pState) {
        return true;
    }

    public int func_180641_l(BlockState pBlockState, World pLevel, BlockPos pPos) {
        return 0;
    }

    public ItemStack func_185473_a(IBlockReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((IItemProvider)ModItems.SHULKER);
    }

    @Nullable
    public DyeColor func_190956_e() {
        return DyeColor.YELLOW;
    }
}

