/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMe;
import com.buuz135.findme.network.PositionResponseMessage;
import com.buuz135.findme.proxy.FindMeConfig;
import com.buuz135.findme.tracking.TrackingList;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class PositionRequestMessage {
    private ItemStack stack;

    public PositionRequestMessage(ItemStack stack) {
        this.stack = stack;
        TrackingList.trackItem(stack);
    }

    public PositionRequestMessage() {
    }

    public static List<BlockPos> getBlockPosInAABB(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.field_72338_b; y < axisAlignedBB.field_72337_e; y += 1.0) {
            for (double x = axisAlignedBB.field_72340_a; x < axisAlignedBB.field_72336_d; x += 1.0) {
                for (double z = axisAlignedBB.field_72339_c; z < axisAlignedBB.field_72334_f; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public PositionRequestMessage fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.stack = ItemStack.field_190927_a;
        this.stack = packetBuffer.func_150791_c();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.func_150788_a(this.stack);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            AxisAlignedBB box = new AxisAlignedBB(((NetworkEvent.Context)contextSupplier.get()).getSender().func_233580_cy_()).func_186662_g((double)((Integer)FindMeConfig.COMMON.RADIUS_RANGE.get()).intValue());
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            block0: for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                IInventory inventory;
                TileEntity tileEntity = ((NetworkEvent.Context)contextSupplier.get()).getSender().field_70170_p.func_175625_s(blockPos);
                if (tileEntity == null) continue;
                tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (handler.getStackInSlot(i).func_190926_b() || !this.compareItems(this.stack, handler.getStackInSlot(i))) continue;
                        blockPosList.add(blockPos);
                        break;
                    }
                });
                if (!(tileEntity instanceof IInventory) || (inventory = (IInventory)tileEntity).func_191420_l()) continue;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i).func_190926_b() || !this.compareItems(this.stack, inventory.func_70301_a(i))) continue;
                    blockPosList.add(blockPos);
                    continue block0;
                }
            }
            if (!blockPosList.isEmpty()) {
                FindMe.NETWORK.sendTo((Object)new PositionResponseMessage(blockPosList), ((NetworkEvent.Context)contextSupplier.get()).getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    private boolean compareItems(ItemStack first, ItemStack second) {
        if (((Boolean)FindMeConfig.COMMON.IGNORE_ITEM_DAMAGE.get()).booleanValue()) {
            return first.func_185136_b(second);
        }
        return first.func_77969_a(second);
    }
}

