/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.crafting;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thetadev.constructionwand.api.IWandUpgrade;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.items.wand.ItemWand;

public class RecipeWandUpgrade
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<RecipeWandUpgrade> SERIALIZER = new SpecialRecipeSerializer(RecipeWandUpgrade::new);

    public RecipeWandUpgrade(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        ItemStack wand = null;
        IWandUpgrade upgrade = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (wand == null && stack.func_77973_b() instanceof ItemWand) {
                wand = stack;
                continue;
            }
            if (upgrade == null && stack.func_77973_b() instanceof IWandUpgrade) {
                upgrade = (IWandUpgrade)stack.func_77973_b();
                continue;
            }
            return false;
        }
        if (wand == null || upgrade == null) {
            return false;
        }
        return !new WandOptions(wand).hasUpgrade(upgrade) && ConfigServer.getWandProperties(wand.func_77973_b()).isUpgradeable();
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack wand = null;
        IWandUpgrade upgrade = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemWand) {
                wand = stack;
                continue;
            }
            if (!(stack.func_77973_b() instanceof IWandUpgrade)) continue;
            upgrade = (IWandUpgrade)stack.func_77973_b();
        }
        if (wand == null || upgrade == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack newWand = wand.func_77946_l();
        new WandOptions(newWand).addUpgrade(upgrade);
        return newWand;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

