/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.data;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class PortalLinkData {
    private RegistryKey<World> dimension;
    private BlockPos pos;
    private boolean caller;
    private String name;
    private boolean token;

    public PortalLinkData(RegistryKey<World> dimension, BlockPos pos, boolean caller, String name, boolean token) {
        this.dimension = dimension;
        this.pos = pos;
        this.caller = caller;
        this.name = name;
        this.token = token;
    }

    public static PortalLinkData readFromNBT(CompoundNBT compound) {
        return new PortalLinkData((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("Dimension"))), BlockPos.func_218283_e((long)compound.func_74763_f("Position")), compound.func_74767_n("Caller"), compound.func_74779_i("Name"), compound.func_74767_n("Token"));
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isCaller() {
        return this.caller;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isToken() {
        return this.token;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74778_a("Dimension", this.dimension.func_240901_a_().toString());
        tagCompound.func_74772_a("Position", this.pos.func_218275_a());
        tagCompound.func_74757_a("Caller", this.caller);
        tagCompound.func_74778_a("Name", this.name);
        tagCompound.func_74757_a("Token", this.token);
        return tagCompound;
    }

    public static enum PortalCallType {
        NORMAL,
        SINGLE,
        FORCE;

    }
}

