/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public interface SideSkipPredicate {
    public static final SideSkipPredicate FALSE = (world, pos, state, adjState, side) -> false;
    public static final SideSkipPredicate CTM = (world, pos, state, adjState, side) -> {
        if (adjState.func_177230_c() instanceof IFramedBlock) {
            if (!((IFramedBlock)adjState.func_177230_c()).getCtmPredicate().test(adjState, side.func_176734_d())) {
                return false;
            }
            TileEntity te = world.func_175625_s(pos.func_177972_a(side));
            if (te instanceof FramedTileEntity) {
                adjState = ((FramedTileEntity)te).getCamoState(side.func_176734_d());
            }
        }
        if (adjState.func_196958_f()) {
            return false;
        }
        if (!((IFramedBlock)state.func_177230_c()).getCtmPredicate().test(state, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, adjState, side);
    };

    public boolean test(IBlockReader var1, BlockPos var2, BlockState var3, BlockState var4, Direction var5);

    public static boolean compareState(IBlockReader world, BlockPos pos, Direction side) {
        return SideSkipPredicate.compareState(world, pos, side, side.func_176734_d());
    }

    public static boolean compareState(IBlockReader world, BlockPos pos, Direction side, Direction camoSide) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te instanceof FramedTileEntity) {
            BlockState adjState = ((FramedTileEntity)te).getCamoState(camoSide);
            if (adjState.func_196958_f()) {
                return false;
            }
            return SideSkipPredicate.compareState(world, pos, adjState, camoSide);
        }
        return false;
    }

    public static boolean compareState(IBlockReader world, BlockPos pos, BlockState adjState, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            BlockState state = ((FramedTileEntity)te).getCamoState(side);
            return state == adjState && !state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_200015_d(world, pos) && adjState.func_200015_d(world, pos.func_177972_a(side));
        }
        return false;
    }
}

