/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.container.FramedStorageContainer;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public class FramedStorageTileEntity
extends FramedTileEntity
implements INamedContainerProvider {
    public static final ITextComponent TITLE = new TranslationTextComponent("title.framedblocks:framed_secret_storage");
    private final ItemStackHandler itemHandler = new ItemStackHandler(36){

        protected void onContentsChanged(int slot) {
            FramedStorageTileEntity.this.func_70296_d();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public FramedStorageTileEntity() {
        super((TileEntityType)FBContent.tileTypeFramedSecretStorage.get());
    }

    protected FramedStorageTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void open(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public void clearContents() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public int getAnalogOutputSignal() {
        int stacks = 0;
        float fullness = 0.0f;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            float sizeLimit = Math.min(this.itemHandler.getSlotLimit(i), stack.func_77976_d());
            fullness += (float)stack.func_190916_E() / sizeLimit;
            ++stacks;
        }
        return MathHelper.func_76141_d((float)((fullness /= (float)this.itemHandler.getSlots()) * 14.0f)) + (stacks > 0 ? 1 : 0);
    }

    @Override
    public CompoundNBT writeToBlueprint() {
        return super.func_189515_b(new CompoundNBT());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("inventory", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    public ITextComponent func_145748_c_() {
        return TITLE;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new FramedStorageContainer(windowId, inv, this);
    }
}

